/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Logger;
import de.governikus.updater.Project;
import de.governikus.updater.client.UpdaterClassLoader;
import de.governikus.updater.fetching.LocalProjectFetcher;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class ApplicationStarter {
    private final Project project;
    private final UpdaterClassLoader classLoader = new UpdaterClassLoader();

    public ApplicationStarter(Path updateFile, Path libsFolder) {
        LocalProjectFetcher localProjectFetcher = new LocalProjectFetcher(updateFile, libsFolder);
        try {
            this.project = localProjectFetcher.getProject();
        }
        catch (JAXBException | IOException | XMLStreamException | SAXException e) {
            throw new SecurityException(e);
        }
    }

    public void addArtefactsToClassLoader(Set<Path> extractedFiles) {
        for (ArtefactType artefact : this.project.getSoftware().getArtefacts().getArtefact()) {
            this.classLoader.addArtefact(artefact);
        }
        for (ArtefactType artefact : this.project.getConfiguration().getArtefacts().getArtefact()) {
            this.classLoader.addArtefact(artefact);
        }
        if (extractedFiles != null) {
            for (Path file : extractedFiles) {
                try {
                    this.classLoader.addURL(file.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    Logger.error((String)("Could not add extracted artefact " + file + " to class loader"), (Throwable)e);
                }
            }
        }
        Logger.debug((String)this.classLoader.getFormattedList());
    }

    public void run(String[] args) {
        try {
            Class<?> c = this.classLoader.loadClass(this.project.getSoftware().getMainClass());
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Method main = c.getMethod("main", String[].class);
            main.invoke(c, new Object[]{args});
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("The provided update file points to a main method that can't be started", e);
        }
    }
}

