/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import com.sun.istack.Nullable;
import de.governikus.updater.ArtefactType;
import de.governikus.updater.Logger;
import de.governikus.updater.Project;
import de.governikus.updater.Step;
import de.governikus.updater.SystemPropertyKey;
import de.governikus.updater.Utils;
import de.governikus.updater.client.ChmodUtil;
import de.governikus.updater.client.Progress;
import de.governikus.updater.client.ProgressListener;
import de.governikus.updater.security.JarVerifier;
import de.governikus.updater.security.ZipFileLimiter;
import de.governikus.updater.utils.FileSystemUtils;
import de.governikus.updater.utils.StreamUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ArtefactUpdater {
    private final Map<String, ArtefactType> artefacts = new HashMap<String, ArtefactType>();
    private final Set<ArtefactType> newArtefacts = new HashSet<ArtefactType>();
    private final Project localProject;
    private final Map<String, ArtefactType> allRemoteArtefacts;
    private final Path tempDirectory;
    private final ProgressListener progressListener;

    public ArtefactUpdater(@Nullable Project localProject, Project remoteProject, Path tempDirectory, ProgressListener progressListener) {
        this.localProject = localProject;
        this.allRemoteArtefacts = Stream.concat(remoteProject.getSoftware().getArtefacts().getArtefact().stream(), remoteProject.getConfiguration().getArtefacts().getArtefact().stream()).collect(Collectors.toMap(ArtefactUpdater::getArtefactId, artefact -> artefact));
        this.tempDirectory = tempDirectory;
        this.progressListener = progressListener;
        this.loadLocalArtefacts();
    }

    private void loadLocalArtefacts() {
        if (this.localProject != null) {
            for (ArtefactType artefact : this.localProject.getSoftware().getArtefacts().getArtefact()) {
                this.artefacts.put(ArtefactUpdater.getArtefactId(artefact), artefact);
            }
            for (ArtefactType artefact : this.localProject.getConfiguration().getArtefacts().getArtefact()) {
                this.artefacts.put(ArtefactUpdater.getArtefactId(artefact), artefact);
            }
        }
    }

    public boolean planUpdate() {
        boolean changes = false;
        changes |= this.removeOldArtefacts();
        changes |= this.updateExistingArtefacts();
        changes |= this.updateManipulatedArtefacts();
        changes |= this.addNewArtefacts();
        return changes |= this.addInflateArtefacts();
    }

    public void downloadUpdate() throws IOException, URISyntaxException {
        Path dir = this.tempDirectory;
        Progress copyProgress = new Progress(Step.COPY, this.progressListener);
        this.copyLocalArtefacts(dir, copyProgress);
        Progress downloadProgress = new Progress(Step.LOAD, this.progressListener);
        this.downloadRemoteArtefacts(dir, downloadProgress);
    }

    public void applyUpdate(Path destination) throws IOException {
        if (Files.exists(destination, new LinkOption[0])) {
            FileSystemUtils.deleteDirectory((Path)destination);
        }
        FileSystemUtils.moveDirectory((Path)this.tempDirectory, (Path)destination);
        long start = System.currentTimeMillis();
        ChmodUtil.setWritableRecursively(destination, null, null, null);
        Logger.debug((String)("Time to chmod: " + (System.currentTimeMillis() - start)));
    }

    private boolean removeOldArtefacts() {
        return this.artefacts.entrySet().removeIf(entry -> !this.allRemoteArtefacts.containsKey(entry.getKey()));
    }

    private boolean updateExistingArtefacts() {
        boolean changed = false;
        for (Map.Entry<String, ArtefactType> entry : this.allRemoteArtefacts.entrySet()) {
            ArtefactType localArtefact = this.artefacts.get(entry.getKey());
            if (localArtefact == null || !ArtefactUpdater.isNewer(entry.getValue(), localArtefact) && localArtefact.getFile() != null) continue;
            this.artefacts.remove(entry.getKey());
            this.newArtefacts.add(entry.getValue());
            changed = true;
        }
        return changed;
    }

    private boolean updateManipulatedArtefacts() {
        return this.artefacts.entrySet().removeIf(entry -> {
            boolean remove = false;
            Path file = Path.of(((ArtefactType)entry.getValue()).getFile(), new String[0]);
            try {
                remove |= Files.size(file) != ((ArtefactType)entry.getValue()).getLength();
            }
            catch (IOException e) {
                remove = true;
            }
            if (!remove && ((ArtefactType)entry.getValue()).getFile().endsWith(".jar")) {
                try {
                    JarVerifier.verify((Path)file);
                }
                catch (IOException | SecurityException e) {
                    remove = true;
                }
            }
            return remove;
        });
    }

    private boolean addNewArtefacts() {
        boolean changed = false;
        for (Map.Entry<String, ArtefactType> entry : this.allRemoteArtefacts.entrySet()) {
            if (this.artefacts.containsKey(entry.getKey())) continue;
            this.newArtefacts.add(entry.getValue());
            changed = true;
        }
        return changed;
    }

    private boolean addInflateArtefacts() {
        return this.artefacts.values().stream().anyMatch(artefact -> Boolean.TRUE.equals(artefact.isInflate()));
    }

    private void copyLocalArtefacts(Path destination, Progress progress) throws IOException {
        if (this.artefacts.isEmpty()) {
            return;
        }
        List<ArtefactType> localArtefacts = List.copyOf(this.artefacts.values());
        progress.setCount(localArtefacts.size());
        for (ArtefactType original : localArtefacts) {
            Path originalFile;
            progress.increase(1L);
            Logger.info((String)("Copy artefact : " + original.getName() + " - " + original.getFile()));
            if (original.getFile() == null || !Files.exists(originalFile = Path.of(original.getFile(), new String[0]), new LinkOption[0])) continue;
            Path copiedFile = destination.resolve(Utils.getLocalPath((ArtefactType)original));
            Files.createDirectories(copiedFile.getParent(), new FileAttribute[0]);
            Files.copy(originalFile, copiedFile, new CopyOption[0]);
            ArtefactType copy = ArtefactUpdater.cloneArtefact(original);
            copy.setFile(copiedFile.toAbsolutePath().toString());
            this.artefacts.put(ArtefactUpdater.getArtefactId(copy), copy);
        }
    }

    private void downloadRemoteArtefacts(Path destination, Progress progress) throws IOException, URISyntaxException {
        if (this.newArtefacts.isEmpty()) {
            return;
        }
        long totalLength = this.newArtefacts.stream().map(ArtefactType::getLength).reduce(0L, Long::sum);
        progress.setCount((int)totalLength);
        for (ArtefactType remote : this.newArtefacts) {
            Path target = ArtefactUpdater.downloadArtefact(remote, destination, progress);
            ArtefactType local = ArtefactUpdater.cloneArtefact(remote);
            local.setFile(target.toAbsolutePath().toString());
            local.setLength(Files.size(target));
            this.artefacts.put(ArtefactUpdater.getArtefactId(local), local);
        }
    }

    private static boolean isNewer(ArtefactType newer, ArtefactType older) {
        return newer.getVersion().compareTo(older.getVersion()) > 0;
    }

    private static String getArtefactId(ArtefactType artefact) {
        return artefact.getName() + artefact.getOs() + artefact.getArch();
    }

    public static ArtefactType cloneArtefact(ArtefactType original) {
        ArtefactType clone = new ArtefactType();
        clone.setVersion(original.getVersion());
        clone.setName(original.getName());
        clone.setLength(original.getLength());
        clone.setFile(original.getFile());
        clone.setConfig(original.isConfig());
        clone.setInflate(original.isInflate());
        clone.setNative(original.isNative());
        clone.setOs(original.getOs());
        clone.setArch(original.getArch());
        return clone;
    }

    private static Path downloadArtefact(ArtefactType remoteArtefact, Path targetDirectory, Progress progress) throws IOException, URISyntaxException {
        Object targetPath = targetDirectory.toAbsolutePath().toString();
        targetPath = (String)targetPath + targetDirectory.getFileSystem().getSeparator() + Utils.getLocalPath((ArtefactType)remoteArtefact);
        Path target = Path.of((String)targetPath, new String[0]);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Object source = System.getProperty(SystemPropertyKey.DOWNLOAD_SERVER_URL.key);
        source = (String)source + Utils.getLocalPath((ArtefactType)remoteArtefact);
        Logger.debug((String)("Downloading artefact: " + remoteArtefact.getName()));
        URLConnection connection = new URI((String)source).toURL().openConnection();
        connection.setUseCaches(false);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(connection.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(target.toFile());){
            int transferred;
            FileChannel fileChannel = fileOutputStream.getChannel();
            long position = 0L;
            while ((transferred = (int)fileChannel.transferFrom(readableByteChannel, position, 0x500000L)) > 0) {
                position += (long)transferred;
                progress.increase(transferred);
            }
        }
        return target;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<Path> inflate(ArtefactType artefact, Path folder) {
        ZipFileLimiter zipFileLimiter = new ZipFileLimiter(Path.of(artefact.getFile(), new String[0]));
        HashSet<Path> extracted = new HashSet<Path>();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(artefact.getFile()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path target;
                zipFileLimiter.addEntry();
                if (entry.isDirectory() || entry.getName().contains("META-INF")) continue;
                if (Boolean.TRUE.equals(artefact.isNative())) {
                    target = folder.resolve(entry.getName());
                } else {
                    String path = artefact.getName().substring(0, artefact.getName().lastIndexOf(46));
                    target = folder.resolve(path).resolve(entry.getName());
                }
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                ZipFileLimiter.SafeInputStream is = zipFileLimiter.getSafeInputStreamFor((InputStream)zis);
                if (Files.exists(target, new LinkOption[0]) && !FileSystemUtils.tryDeleteFile((Path)target)) {
                    InputStream existingFile = Files.newInputStream(target, new OpenOption[0]);
                    try {
                        if (!StreamUtils.contentEquals((InputStream)is, (InputStream)existingFile)) continue;
                        extracted.add(target);
                        continue;
                    }
                    finally {
                        if (existingFile == null) continue;
                        existingFile.close();
                        continue;
                    }
                }
                Files.copy((InputStream)is, target, StandardCopyOption.REPLACE_EXISTING);
                extracted.add(target);
            }
            return extracted;
        }
        catch (IOException e) {
            Logger.error((String)("Could not inflate artefact " + artefact.getName()), (Throwable)e);
        }
        return extracted;
    }
}

