/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.Logger;
import de.governikus.updater.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public final class ChmodUtil {
    private static final String EVERYONE_SID = "S-1-1-0";

    private ChmodUtil() {
    }

    public static void setWritableRecursively(Path fileToChange, List<AclEntry> aclListDirs, List<AclEntry> aclListFiles, String everyoneAccountName) throws IOException {
        File[] files;
        block17: {
            if (!Utils.runningInConsole()) {
                return;
            }
            if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows")) {
                AclEntry.Builder aclBuilder;
                AclFileAttributeView aclView = Files.getFileAttributeView(fileToChange, AclFileAttributeView.class, new LinkOption[0]);
                if (aclListDirs == null) {
                    everyoneAccountName = ChmodUtil.getEveryoneAccount();
                    aclBuilder = AclEntry.newBuilder();
                    aclBuilder.setPrincipal(fileToChange.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(everyoneAccountName));
                    aclBuilder.setPermissions(AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.ADD_FILE, AclEntryPermission.ADD_SUBDIRECTORY, AclEntryPermission.DELETE_CHILD, AclEntryPermission.LIST_DIRECTORY, AclEntryPermission.WRITE_OWNER, AclEntryPermission.EXECUTE, AclEntryPermission.DELETE);
                    aclBuilder.setType(AclEntryType.ALLOW);
                    aclListDirs = new ArrayList<AclEntry>(aclView.getAcl());
                    aclListDirs.add(0, aclBuilder.build());
                }
                if (aclListFiles == null) {
                    aclBuilder = AclEntry.newBuilder();
                    aclBuilder.setPrincipal(fileToChange.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(everyoneAccountName));
                    aclBuilder.setPermissions(AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_OWNER, AclEntryPermission.DELETE);
                    aclBuilder.setType(AclEntryType.ALLOW);
                    aclListFiles = new ArrayList<AclEntry>(aclView.getAcl());
                    aclListFiles.add(0, aclBuilder.build());
                }
                if (fileToChange.toFile().isDirectory()) {
                    try {
                        aclView.setAcl(aclListDirs);
                    }
                    catch (Exception e) {
                        Logger.info((String)("Could not set directory " + fileToChange + " as writable. No problem as long as directory structure is unchanged. Continuing normally"));
                    }
                } else {
                    try {
                        aclView.setAcl(aclListFiles);
                    }
                    catch (Exception e) {
                        if (fileToChange.toFile().canWrite()) {
                            Logger.info((String)("Could not set file " + fileToChange + " as writable. Should only happen with unchanged files. No problem since the file is writeable. Continuing normally"));
                            break block17;
                        }
                        Logger.error((String)("Could not set file " + fileToChange + " as writable. Continuing, problems may occur."));
                    }
                }
            } else {
                try {
                    HashSet<PosixFilePermission> oldSet = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(fileToChange, new LinkOption[0]));
                    oldSet.add(PosixFilePermission.OTHERS_READ);
                    oldSet.add(PosixFilePermission.OTHERS_WRITE);
                    Files.setPosixFilePermissions(fileToChange, oldSet);
                }
                catch (FileSystemException e) {
                    if (Files.isWritable(fileToChange)) {
                        Logger.debug((String)"Can not set file as writable, but it already is. Continuing normally");
                    }
                    Logger.info((String)("File " + fileToChange + " could not be set writable!"), (Throwable)e);
                }
            }
        }
        Logger.debug((String)("Successfully set writable for " + fileToChange));
        if (fileToChange.toFile().isDirectory() && (files = fileToChange.toFile().listFiles()) != null) {
            for (File file : files) {
                ChmodUtil.setWritableRecursively(file.toPath(), aclListDirs, aclListFiles, everyoneAccountName);
            }
        }
    }

    private static String getEveryoneAccount() throws IOException {
        Object everyoneAccountName = "\\Jeder";
        Process wmic = Runtime.getRuntime().exec("wmic path Win32_SystemAccount");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(wmic.getInputStream(), StandardCharsets.UTF_8));){
            Optional<String> everyoneLine = br.lines().filter(line -> line.contains(EVERYONE_SID)).findFirst();
            if (everyoneLine.isPresent()) {
                everyoneAccountName = "\\" + everyoneLine.get().replaceAll(".*\\s([^\\s]+)\\s*S-1-1-0.*", "$1");
            }
        }
        return everyoneAccountName;
    }
}

