/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.client.Reg;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.proxy.AbstractProxySelector;
import de.governikus.updater.client.proxy.CoreController;
import de.governikus.updater.client.proxy.LinuxProxySelector;
import de.governikus.updater.client.proxy.ProxyConstants;
import de.governikus.updater.client.proxy.WindowsProxySelector;
import de.governikus.updater.client.proxy.pac.PacProxySelector;
import de.governikus.updater.utils.SystemEnvironment;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Nettings
extends Authenticator {
    private final CoreController controller;
    private final Map<String, AbstractMap.SimpleEntry<String, String>> credentialsMap;
    private static Nettings instance;

    private Nettings(CoreController c) {
        ProxySelector proxy;
        this.controller = c;
        ProxySelector proxySelector = proxy = this.controller.useSystemNettings() ? Nettings.readSystemProxy() : null;
        if (proxy != null) {
            Logger.info((String)("Using " + proxy.getClass().getName() + " as ProxySelector"));
            if (proxy instanceof PacProxySelector) {
                ProxySelector.setDefault(proxy);
            }
        }
        if (!System.getProperties().containsKey("sun.net.client.defaultConnectTimeout")) {
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        }
        if (!System.getProperties().containsKey("sun.net.client.defaultReadTimeout")) {
            System.setProperty("sun.net.client.defaultReadTimeout", "180000");
        }
        try {
            Properties props = new Properties();
            Map<Object, Object> propertySet = System.getProperties().entrySet().stream().filter(e -> !e.getKey().toString().toLowerCase().contains("password")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            props.putAll(propertySet);
            props.store(System.err, "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.credentialsMap = new HashMap<String, AbstractMap.SimpleEntry<String, String>>();
        Authenticator.setDefault(this);
    }

    public static Nettings create(UpdaterController c) {
        instance = new Nettings(c);
        return instance;
    }

    public static Nettings getInstance() {
        return instance;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication;
        AbstractMap.SimpleEntry<String, String> savedCredentials;
        String key = this.getRequestingScheme() + this.getRequestorType() + this.getRequestingHost() + this.getRequestingPort();
        if (Nettings.checkSystemProperties()) {
            String user = System.getProperty(ProxyConstants.HTTP_PROXY_USER.value());
            String password = System.getProperty(ProxyConstants.HTTP_PROXY_PASS.value());
            if (user != null && password != null) {
                this.credentialsMap.put(key, new AbstractMap.SimpleEntry<String, String>(user, password));
            }
        }
        if ((savedCredentials = this.credentialsMap.get(key)) == null) {
            passwordAuthentication = this.controller.getUsernameAndPassword(this.getRequestingScheme(), this.getRequestorType(), this.getRequestingHost(), this.getRequestingPort(), this.getRequestingURL(), this.getRequestingPrompt());
            if (passwordAuthentication != null) {
                this.credentialsMap.put(key, new AbstractMap.SimpleEntry<String, String>(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword())));
            }
        } else {
            passwordAuthentication = new PasswordAuthentication(savedCredentials.getKey(), savedCredentials.getValue().toCharArray());
        }
        return passwordAuthentication;
    }

    public static ProxySelector readSystemProxy() {
        OSType currentOS = SystemEnvironment.currentOSType();
        if (currentOS == null) {
            return Nettings.emptyProxySelector();
        }
        switch (currentOS) {
            case WINDOWS: {
                PacProxySelector pacProxySelector;
                if (Nettings.checkSystemProperties()) {
                    return null;
                }
                String regPath = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                String key = "AutoConfigURL";
                List<Object> pacEntries = new ArrayList();
                try {
                    pacEntries = Reg.query(regPath, key);
                }
                catch (IOException | InterruptedException ex) {
                    Logger.error((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                if (!pacEntries.isEmpty() && (pacProxySelector = Nettings.buildPacProxySelector()) != null) {
                    return pacProxySelector;
                }
                return new WindowsProxySelector();
            }
            case LINUX: {
                return new LinuxProxySelector();
            }
        }
        return Nettings.emptyProxySelector();
    }

    private static boolean checkSystemProperties() {
        String httpHost = System.getProperty(ProxyConstants.HTTP_PROXY_HOST.value());
        String httpPort = System.getProperty(ProxyConstants.HTTP_PROXY_PORT.value());
        String httpUser = System.getProperty(ProxyConstants.HTTP_PROXY_USER.value());
        String httpPassword = System.getProperty(ProxyConstants.HTTP_PROXY_PASS.value());
        if (httpHost != null && httpPort != null) {
            System.setProperty(ProxyConstants.HTTP_PROXY_SET.value(), "true");
            System.setProperty(ProxyConstants.HTTPS_PROXY_HOST.value(), httpHost);
            System.setProperty(ProxyConstants.HTTPS_PROXY_PORT.value(), httpPort);
            if (httpUser != null && httpPassword != null) {
                System.setProperty(ProxyConstants.HTTPS_PROXY_USER.value(), httpUser);
                System.setProperty(ProxyConstants.HTTPS_PROXY_PASS.value(), httpPassword);
            }
            return true;
        }
        String httpsHost = System.getProperty(ProxyConstants.HTTPS_PROXY_HOST.value());
        String httpsPort = System.getProperty(ProxyConstants.HTTPS_PROXY_PORT.value());
        String httpsUser = System.getProperty(ProxyConstants.HTTPS_PROXY_USER.value());
        String httpsPassword = System.getProperty(ProxyConstants.HTTPS_PROXY_PASS.value());
        if (httpsHost != null && httpsPort != null) {
            System.setProperty(ProxyConstants.HTTP_PROXY_SET.value(), "true");
            System.setProperty(ProxyConstants.HTTP_PROXY_HOST.value(), httpsHost);
            System.setProperty(ProxyConstants.HTTP_PROXY_PORT.value(), httpsPort);
            if (httpsUser != null && httpsPassword != null) {
                System.setProperty(ProxyConstants.HTTP_PROXY_USER.value(), httpsUser);
                System.setProperty(ProxyConstants.HTTP_PROXY_PASS.value(), httpsPassword);
            }
        }
        return false;
    }

    private static ProxySelector emptyProxySelector() {
        return new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return AbstractProxySelector.NO_PROXY_LIST;
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
    }

    private static PacProxySelector buildPacProxySelector() {
        try {
            return new PacProxySelector();
        }
        catch (IOException e) {
            Throwable t = e;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            Logger.error((String)("Error creating the PacProxySelector. " + t.getMessage()));
            return null;
        }
    }
}

