/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.SystemPropertyKey;
import de.governikus.updater.utils.SystemEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class PropertiesManager {
    private static final String FILENAME = "updater.properties";
    private static final PropertiesManager instance = new PropertiesManager();
    private Properties properties;
    private final Path propertiesFile = this.getFilePath();

    public static PropertiesManager getAppInstance() {
        return instance;
    }

    private PropertiesManager() {
    }

    private Path getFilePath() {
        Path file;
        String manufacturerName = System.getProperty(SystemPropertyKey.MANUFACTURER_NAME.key);
        if (System.getProperties().containsKey(SystemPropertyKey.GC_FOLDER.key)) {
            file = Path.of(System.getProperty(SystemPropertyKey.GC_FOLDER.key), manufacturerName);
        } else if (System.getenv().containsKey("LOCALAPPDATA")) {
            file = Path.of(System.getenv("LOCALAPPDATA"), manufacturerName);
        } else if (System.getProperties().containsKey("user.home")) {
            file = Path.of(System.getProperty("user.home"), new String[0]);
            file = OSType.MAC.equals((Object)SystemEnvironment.currentOSType()) ? file.resolve("Library").resolve("Preferences").resolve(manufacturerName) : file.resolve("." + manufacturerName);
        } else {
            Logger.error((String)("No location for saving the application properties could be found. Please set the system property '" + SystemPropertyKey.GC_FOLDER.key + "' to provide a location."));
            this.properties = new Properties();
            return null;
        }
        String applicationName = System.getProperty(SystemPropertyKey.APPLICATION_FOLDER_NAME.key);
        return file.resolve(applicationName).resolve(FILENAME);
    }

    private void load() {
        if (this.properties == null && this.propertiesFile != null) {
            this.properties = new Properties();
            try {
                Files.createDirectories(this.propertiesFile.getParent(), new FileAttribute[0]);
                try (InputStream stream = Files.newInputStream(this.propertiesFile, new OpenOption[0]);){
                    this.properties.load(stream);
                }
            }
            catch (NoSuchFileException stream) {
            }
            catch (IOException e) {
                Logger.error((String)("Could not load app properties from file " + this.propertiesFile), (Throwable)e);
            }
        }
    }

    private void store() {
        if (this.properties != null && this.propertiesFile != null) {
            try {
                Files.createDirectories(this.propertiesFile.getParent(), new FileAttribute[0]);
                try (OutputStream os = Files.newOutputStream(this.propertiesFile, new OpenOption[0]);){
                    this.properties.store(os, null);
                }
            }
            catch (IOException e) {
                Logger.error((String)("Could not store app properties in file " + this.propertiesFile), (Throwable)e);
            }
        }
    }

    public synchronized String getProperty(String key, String defaultValue) {
        this.load();
        return this.properties.getProperty(key, defaultValue);
    }

    public synchronized void put(Object key, Object value) {
        this.load();
        this.properties.put(key, value);
        this.store();
    }

    public synchronized void remove(Object key) {
        this.load();
        this.properties.remove(key);
        this.store();
    }
}

