/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.Logger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class Reg {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Entry> query(String regPath, String key) throws IOException, InterruptedException {
        String token;
        int response;
        StringBuilder sb;
        String cmd = "reg query \"" + regPath + "\"";
        cmd = key != null ? cmd + " /v \"" + key + "\"" : cmd;
        Logger.debug((String)("CMD: \"" + cmd + "\""));
        Process process = Runtime.getRuntime().exec(cmd);
        try (InputStreamReader is = new InputStreamReader(process.getInputStream());){
            sb = new StringBuilder();
            char[] buf = new char[8192];
            int read = is.read(buf);
            while (read != -1) {
                sb.append(buf, 0, read);
                read = is.read(buf);
            }
        }
        finally {
            response = process.waitFor();
        }
        if (response != 0) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n", false);
        while (st.hasMoreTokens() && !(token = st.nextToken().trim()).equals(regPath)) {
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (st.hasMoreTokens()) {
            String token2 = st.nextToken().trim();
            if (token2.isEmpty()) continue;
            entries.add(new Entry(regPath, token2));
        }
        return entries;
    }

    public static class Entry {
        public final String path;
        public final String key;
        public final DType type;
        public Object value;

        public Entry(String p, String k, DType t, Object v) {
            this.path = p;
            this.key = k;
            this.type = t;
            this.value = v;
        }

        public Entry(String p, String line) {
            this.path = p;
            if (!line.startsWith(this.path)) {
                line = line.replaceAll("    ", "\t");
                String[] split = line.split("\t");
                this.key = split[0];
                this.type = DType.valueOf(split[1]);
                if (split.length == 3) {
                    this.value = this.type.getJavaType(split[2]);
                }
            } else {
                this.key = line.substring(this.path.length() + 1);
                this.type = null;
                this.value = null;
            }
        }

        public String toString() {
            return "Entry[key=" + this.key + ", type=" + this.type + ", value=" + this.value + "]";
        }
    }

    public static enum DType {
        REG_SZ,
        REG_MULTI_SZ,
        REG_DWORD_BIG_ENDIAN,
        REG_DWORD,
        REG_QWORD,
        REG_BINARY,
        REG_DWORD_LITTLE_ENDIAN,
        REG_LINK,
        REG_FULL_RESOURCE_DESCRIPTOR,
        REG_EXPAND_SZ;


        public Object getJavaType(String l) {
            if (this == REG_SZ) {
                return l;
            }
            if (this == REG_MULTI_SZ) {
                l = l.substring(0, l.length() - 4);
                l = l.replace("\\0", "\n").trim();
                return l;
            }
            if (this == REG_DWORD || this == REG_QWORD) {
                String s = l;
                if (s.startsWith("0x")) {
                    s = s.substring(2);
                    return Long.valueOf(s, 16);
                }
                return Long.valueOf(s, 10);
            }
            if (this == REG_BINARY) {
                return l.getBytes();
            }
            return l;
        }
    }
}

