/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.Project;
import de.governikus.updater.ProjectType;
import de.governikus.updater.Step;
import de.governikus.updater.SystemPropertyKey;
import de.governikus.updater.Utils;
import de.governikus.updater.client.ApplicationStarter;
import de.governikus.updater.client.ArtefactUpdater;
import de.governikus.updater.client.Nettings;
import de.governikus.updater.client.Progress;
import de.governikus.updater.client.Reg;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.checking.ConfigurationUpdateChecker;
import de.governikus.updater.client.checking.InstallationUpdateChecker;
import de.governikus.updater.client.checking.SoftwareUpdateChecker;
import de.governikus.updater.client.gui.DefaultGUIUpdateController;
import de.governikus.updater.client.proxy.ProxyConstants;
import de.governikus.updater.client.security.ProjectVerifier;
import de.governikus.updater.fetching.LocalProjectFetcher;
import de.governikus.updater.fetching.RemoteProjectFetcher;
import de.governikus.updater.utils.FileSystemUtils;
import de.governikus.updater.utils.SystemEnvironment;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class Updater {
    private static final String TEMP_FOLDER_NAME = "temp";
    public static final String LIBS_FOLDER_NAME = "libs";
    private String[] args;
    private final UpdaterController updateController;
    private Project localProject;
    private Project remoteProject;
    private final String appName;
    private Path localAppFolder;
    private final ProxySelector defaultProxySelector;
    private URI updateXmlUri = null;
    private boolean abortUpdate = false;
    private boolean shouldUpdateSoftware;
    private boolean mustUpdateSoftware;
    private boolean mustUpdateConfiguration;
    private RemoteProjectFetcher remoteProjectFetcher;
    private boolean localProjectAvailable = false;
    private boolean remoteProjectAvailable = false;
    private Set<Path> extractedFiles = null;

    private Updater(String[] list) {
        this.args = list;
        String controllerDelegateImplClassname = System.getProperty(SystemPropertyKey.CONTROLLER_CLASS_NAME.key);
        this.appName = System.getProperty(SystemPropertyKey.APPLICATION_FOLDER_NAME.key);
        this.appendLibsToLibraryPath();
        Logger.initLogFiles((Path)this.getLocalAppFolder());
        UpdaterController d = null;
        if (controllerDelegateImplClassname != null) {
            try {
                Class<?> delegateClass = Class.forName(controllerDelegateImplClassname);
                Constructor<?> constructor = delegateClass.getConstructor(Updater.class);
                d = (UpdaterController)constructor.newInstance(this);
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
        this.updateController = Objects.requireNonNullElseGet(d, () -> new DefaultGUIUpdateController(this));
        Logger.debug((String)("updateController class=" + this.updateController.getClass().getName()));
        this.defaultProxySelector = ProxySelector.getDefault();
        Nettings.create(this.updateController);
    }

    private void appendLibsToLibraryPath() {
        Object javaLibraryPath = System.getProperty("java.library.path");
        if (!((String)javaLibraryPath).contains(this.getLibsFolder().toAbsolutePath().toString())) {
            javaLibraryPath = (String)javaLibraryPath + ";" + this.getLibsFolder().toAbsolutePath();
            System.setProperty("java.library.path", (String)javaLibraryPath);
        }
    }

    public String getAppName() {
        return this.appName;
    }

    private String getUpdateFileName() {
        return System.getProperty(SystemPropertyKey.UPDATE_FILENAME.key);
    }

    public Path getLocalAppFolder() {
        Path folder;
        if (this.localAppFolder != null) {
            return this.localAppFolder;
        }
        String path = System.getProperty(SystemPropertyKey.GC_FOLDER.key, null);
        if (path != null) {
            folder = Path.of(path, new String[0]);
            this.tryUsingApplicationFolder(folder);
        }
        if (this.localAppFolder == null && SystemEnvironment.currentOSType() == OSType.WINDOWS && (folder = this.getCommonAppDataFolder()) != null) {
            this.tryUsingApplicationFolder(folder);
        }
        if (this.localAppFolder == null) {
            path = System.getProperty("user.home");
            folder = Path.of(path, new String[0]);
            this.tryUsingApplicationFolder(folder);
        }
        if (this.localAppFolder == null) {
            path = System.getProperty("user.dir");
            folder = Path.of(path, new String[0]);
            this.tryUsingApplicationFolder(folder);
        }
        if (this.localAppFolder == null) {
            path = System.getProperty("java.io.tmpdir");
            folder = Path.of(path, new String[0]);
            this.tryUsingApplicationFolder(folder);
        }
        if (this.localAppFolder == null) {
            throw new SecurityException("Could not get a directory to store app data in");
        }
        Logger.info((String)("Application folder: " + this.localAppFolder.toAbsolutePath()));
        return this.localAppFolder;
    }

    private void tryUsingApplicationFolder(Path baseFolder) {
        String manufacturerName = System.getProperty(SystemPropertyKey.MANUFACTURER_NAME.key);
        Path folder = baseFolder.resolve(manufacturerName).resolve(this.appName);
        if (FileSystemUtils.tryCreateDirectories((Path)folder) && FileSystemUtils.isDirectoryWritable((Path)folder, (boolean)true)) {
            this.localAppFolder = folder;
        } else {
            Logger.info((String)("Can't use " + baseFolder + " as application folder"));
        }
    }

    private Path getCommonAppDataFolder() {
        try {
            String userName;
            String registryPath = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
            String registryKey = "Common AppData";
            List<Reg.Entry> entries = Reg.query(registryPath, registryKey);
            String path = (String)entries.get((int)0).value;
            Path folder = Path.of(path, new String[0]);
            if (Utils.runningInConsole() && (userName = System.getProperty("user.name")) != null) {
                userName = Utils.getValidFileName((String)userName);
                folder = folder.resolve(userName);
            }
            return folder;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void lock() {
        this.updateController.lock();
        Runtime.getRuntime().addShutdownHook(new Thread(this.updateController::unlock));
    }

    public boolean isLocked() {
        return this.updateController.isLocked();
    }

    private Path getTempFolder() {
        return this.getLocalAppFolder().resolve(TEMP_FOLDER_NAME);
    }

    private Path getLibsFolder() {
        return this.getLocalAppFolder().resolve(LIBS_FOLDER_NAME);
    }

    private void readProjects() {
        InstallationUpdateChecker installationUpdateChecker;
        this.updateController.will(Step.READ);
        Path localProjectFile = this.getLocalAppFolder().resolve(this.getUpdateFileName());
        if (Files.exists(localProjectFile, new LinkOption[0])) {
            LocalProjectFetcher localProjectFetcher = new LocalProjectFetcher(localProjectFile, this.getLibsFolder());
            try {
                this.localProject = localProjectFetcher.getProject();
                this.localProjectAvailable = true;
            }
            catch (JAXBException | IOException | XMLStreamException | SAXException e) {
                Logger.info((String)"Could not load local project's xml file", (Throwable)e);
                this.localProject = new Project();
                this.localProject.setProjectType(new ProjectType());
            }
        } else {
            this.localProject = new Project();
            this.localProject.setProjectType(new ProjectType());
        }
        LocalProjectFetcher.setInstallerVersion((Project)this.localProject);
        try {
            this.updateXmlUri = new URI(System.getProperty(SystemPropertyKey.DOWNLOAD_SERVER_URL.key) + this.getUpdateFileName());
            this.remoteProjectFetcher = new RemoteProjectFetcher(this.updateXmlUri.toURL(), this.getLocalAppFolder());
            this.remoteProject = this.remoteProjectFetcher.getProject();
            this.remoteProjectAvailable = true;
        }
        catch (IOException e) {
            UpdaterController.NoRemoteProjectResult result = this.updateController.errorNoRemoteProject(e, this.localProject.getName() != null, this.updateXmlUri);
            if (result == UpdaterController.NoRemoteProjectResult.QUIT) {
                this.abortUpdate = true;
                return;
            }
            this.remoteProject = new Project();
            this.remoteProject.setProjectType(new ProjectType());
        }
        catch (JAXBException | URISyntaxException | XMLStreamException | SAXException e) {
            Logger.error((String)"Could not load remote project's xml file", (Throwable)e);
            this.remoteProject = new Project();
            this.remoteProject.setProjectType(new ProjectType());
        }
        if (this.remoteProjectAvailable && (installationUpdateChecker = new InstallationUpdateChecker(this.localProject.getInstallation(), this.remoteProject.getInstallation(), this.updateController)).shouldUpdate()) {
            this.abortUpdate = true;
            return;
        }
        if (this.localProjectAvailable && this.remoteProjectAvailable) {
            Logger.info((String)("local version: " + this.localProject.getSoftware().getVersion()));
            Logger.info((String)("remote version: " + this.remoteProject.getSoftware().getVersion()));
            SoftwareUpdateChecker softwareUpdateChecker = new SoftwareUpdateChecker(this.localProject.getSoftware(), this.remoteProject.getSoftware(), this.updateController);
            this.shouldUpdateSoftware = softwareUpdateChecker.shouldUpdate();
            this.mustUpdateSoftware = softwareUpdateChecker.mustUpdate();
            ConfigurationUpdateChecker configUpdateChecker = new ConfigurationUpdateChecker(this.localProject.getConfiguration(), this.remoteProject.getConfiguration());
            this.mustUpdateConfiguration = configUpdateChecker.mustUpdate();
        } else {
            this.shouldUpdateSoftware = this.remoteProjectAvailable;
            this.mustUpdateSoftware = this.remoteProjectAvailable;
            this.mustUpdateConfiguration = this.remoteProjectAvailable;
        }
        this.updateController.did(Step.READ);
    }

    private boolean verifyLocalProject() {
        ProjectVerifier localVerifier = new ProjectVerifier(this.localProject, this.getLibsFolder());
        this.extractedFiles = localVerifier.getExtractedFiles();
        Progress progress = new Progress(Step.CHECK_LOCAL, this.updateController.getProgressListener());
        try (Stream<Path> tree = Files.walk(this.getLibsFolder(), new FileVisitOption[0]);){
            progress.setCount(tree.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).count());
        }
        catch (IOException e) {
            Logger.error((String)("Could not count files in " + this.getLibsFolder()), (Throwable)e);
        }
        return localVerifier.verify(progress);
    }

    private boolean updateUsingRemote(ArtefactUpdater artefactUpdater, boolean offerRunningLocalOnFailure) {
        this.updateController.will(Step.LOAD);
        IOException updatingFromRemoteError = null;
        if (!artefactUpdater.planUpdate()) {
            Logger.error((String)"Remote update was intended but nothing changes");
            return false;
        }
        try {
            Files.createDirectories(this.getTempFolder(), new FileAttribute[0]);
            artefactUpdater.downloadUpdate();
            this.updateController.did(Step.LOAD);
            this.updateController.will(Step.COPY);
            artefactUpdater.applyUpdate(this.getLibsFolder());
            this.remoteProjectFetcher.saveUpdateXmlTo(this.getLocalAppFolder().resolve(this.getUpdateFileName()), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            this.updateController.did(Step.COPY);
        }
        catch (URISyntaxException e) {
            String errorMessage = "The uri for the update server is incorrectly built";
            if (offerRunningLocalOnFailure) {
                Logger.error((String)(errorMessage + ": " + e.getMessage()));
                updatingFromRemoteError = new IOException(errorMessage, e);
            }
            throw new IllegalArgumentException(errorMessage, e);
        }
        catch (IOException e) {
            Logger.error((String)"Could not download and apply remote update", (Throwable)e);
            if (offerRunningLocalOnFailure) {
                updatingFromRemoteError = e;
            }
            return false;
        }
        this.updateController.will(Step.VERIFY);
        Path localProjectFile = this.getLocalAppFolder().resolve(this.getUpdateFileName());
        LocalProjectFetcher localProjectFetcher = new LocalProjectFetcher(localProjectFile, this.getLibsFolder());
        try {
            this.localProject = localProjectFetcher.getProject();
            this.localProjectAvailable = true;
        }
        catch (JAXBException | IOException | XMLStreamException | SAXException e) {
            Logger.info((String)"Could not load local project's xml file", (Throwable)e);
            return false;
        }
        LocalProjectFetcher.setInstallerVersion((Project)this.localProject);
        boolean valid = this.verifyLocalProject();
        this.updateController.did(Step.VERIFY);
        if (updatingFromRemoteError != null) {
            if (valid) {
                return this.updateController.errorLoadingRemoteProject(updatingFromRemoteError, this.mustUpdateConfiguration, this.updateXmlUri);
            }
            return false;
        }
        return valid;
    }

    public boolean update() {
        this.updateController.started();
        try {
            boolean success;
            if (Files.exists(this.getTempFolder(), new LinkOption[0])) {
                FileSystemUtils.deleteDirectory((Path)this.getTempFolder());
            }
            this.readProjects();
            if (this.abortUpdate) {
                return false;
            }
            ArtefactUpdater artefactUpdater = new ArtefactUpdater(this.localProject, this.remoteProject, this.getTempFolder(), this.updateController.getProgressListener());
            if (!this.localProjectAvailable && !this.remoteProjectAvailable) {
                Logger.error((String)"Neither a local, nor a remote project could be found");
                success = false;
            } else if (!this.localProjectAvailable) {
                success = this.updateUsingRemote(artefactUpdater, false);
            } else if (!this.remoteProjectAvailable) {
                this.updateController.will(Step.CHECK_LOCAL);
                success = this.verifyLocalProject();
                this.updateController.did(Step.CHECK_LOCAL);
            } else {
                success = this.updateWithBothAvailable(artefactUpdater);
            }
            if (success) {
                this.updateController.finished();
            } else {
                this.updateController.errored(new SecurityException("Local version is not runnable"), null);
            }
            return success;
        }
        catch (Exception e) {
            this.updateController.errored(e, this.updateXmlUri);
            return false;
        }
    }

    private boolean updateWithBothAvailable(ArtefactUpdater artefactUpdater) {
        boolean success;
        if (this.mustUpdateSoftware || this.mustUpdateConfiguration) {
            success = this.updateUsingRemote(artefactUpdater, false);
        } else {
            this.updateController.will(Step.CHECK_LOCAL);
            boolean valid = this.verifyLocalProject();
            this.updateController.did(Step.CHECK_LOCAL);
            success = valid ? (this.shouldUpdateSoftware ? this.updateUsingRemote(artefactUpdater, true) : true) : this.updateUsingRemote(artefactUpdater, false);
        }
        return success;
    }

    public void startApp() {
        Path updateFile = this.getLocalAppFolder().resolve(this.getUpdateFileName());
        if (Files.notExists(updateFile, new LinkOption[0])) {
            throw new IllegalStateException("Local update file does not exist");
        }
        ApplicationStarter starter = new ApplicationStarter(updateFile, this.getLibsFolder());
        starter.addArtefactsToClassLoader(this.extractedFiles);
        Logger.debug((String)"------ System.properties");
        System.getProperties().entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).filter(prop -> !prop.startsWith(ProxyConstants.HTTP_PROXY_PASS.value()) && !prop.startsWith(ProxyConstants.HTTPS_PROXY_PASS.value())).sorted().forEachOrdered(Logger::debug);
        Logger.debug((String)"------ System.properties");
        if (this.updateController.resetProxySelector()) {
            ProxySelector.setDefault(this.defaultProxySelector);
        }
        this.args = this.updateController.processParameters(this.args);
        starter.run(this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        Properties props = new Properties();
        InputStream is = Updater.class.getResourceAsStream("/installer.properties");
        if (is != null) {
            try {
                SystemPropertyKey[] removeIfExistent;
                props.load(is);
                for (SystemPropertyKey key : removeIfExistent = new SystemPropertyKey[]{SystemPropertyKey.CONTROLLER_CLASS_NAME, SystemPropertyKey.DOWNLOAD_SERVER_URL, SystemPropertyKey.UPDATE_FILENAME, SystemPropertyKey.MANUFACTURER_NAME, SystemPropertyKey.APPLICATION_FOLDER_NAME}) {
                    if (System.getProperty(key.key) == null) continue;
                    props.remove(key.key);
                }
                System.getProperties().putAll((Map<?, ?>)props);
                props.list(System.out);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        Updater u = new Updater(args);
        boolean wasLocked = u.isLocked();
        Logger.debug((String)("was locked: " + wasLocked));
        u.lock();
        if (wasLocked) {
            boolean startNewInstance = u.updateController.storeArgumentsForAlreadyStartedApp(args);
            if (startNewInstance) {
                u.startApp();
            }
            return;
        }
        try {
            boolean start = u.update();
            if (u.updateController.getCause() != null || !start) {
                return;
            }
            System.setProperty("already-splashed", "true");
            u.startApp();
        }
        finally {
            u.updateController.quit();
        }
    }
}

