/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class UpdaterClassLoader
extends URLClassLoader {
    public UpdaterClassLoader() {
        super(new URL[0]);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addArtefact(ArtefactType artefact) {
        try {
            if (artefact.getFile() == null) {
                Logger.error((String)("Artefact file is null for " + artefact.getName()));
            }
            this.addURL(Path.of(artefact.getFile(), new String[0]).toUri().toURL());
        }
        catch (MalformedURLException e) {
            Logger.error((String)("Could not add file " + artefact.getFile() + " as url to class loader path"), (Throwable)e);
        }
    }

    public String getFormattedList() {
        URL[] urls;
        StringBuilder sb = new StringBuilder("\n\nLoadable jar files:\n");
        for (URL url : urls = this.getURLs()) {
            String path;
            try {
                path = Path.of(url.toURI()).toAbsolutePath().toString();
            }
            catch (URISyntaxException e) {
                path = url.getPath();
            }
            sb.append("  ").append(path);
            try (JarFile jarFile = new JarFile(path);){
                if (jarFile.getManifest().getMainAttributes().containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
                    sb.append(" (");
                    sb.append(jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                    sb.append(")");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sb.append("\n");
        }
        sb.append('\n');
        return sb.toString();
    }
}

