/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.checking;

import de.governikus.updater.InstallationType;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.checking.UpdateChecker;

public class InstallationUpdateChecker
implements UpdateChecker {
    private final InstallationType local;
    private final InstallationType remote;
    private final int compared;
    private final UpdaterController updaterController;
    private Boolean shouldUpdate;

    public InstallationUpdateChecker(InstallationType local, InstallationType remote, UpdaterController updaterController) {
        this.local = local;
        this.remote = remote;
        this.updaterController = updaterController;
        this.compared = this.compare(local.getVersion(), remote.getVersion());
    }

    @Override
    public boolean isRemoteNewer() {
        return this.compared < 0;
    }

    @Override
    public boolean shouldUpdate() {
        if (this.mustUpdate()) {
            UpdaterController.ShouldReInstallResult result = this.updaterController.installerMandatory(this.local, this.remote);
            return result == UpdaterController.ShouldReInstallResult.REINSTALL;
        }
        if (!this.isRemoteNewer()) {
            return false;
        }
        if (this.shouldUpdate == null) {
            UpdaterController.ShouldReInstallResult result = this.updaterController.installerAvailable(this.local, this.remote);
            this.shouldUpdate = result == UpdaterController.ShouldReInstallResult.REINSTALL;
        }
        return this.shouldUpdate;
    }

    @Override
    public boolean mustUpdate() {
        return this.isRemoteNewer() && Boolean.TRUE.equals(this.remote.isMandatory());
    }
}

