/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.checking;

import de.governikus.updater.SoftwareType;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.checking.UpdateChecker;

public class SoftwareUpdateChecker
implements UpdateChecker {
    private final SoftwareType local;
    private final SoftwareType remote;
    private final int compared;
    private final UpdaterController updaterController;
    private Boolean shouldUpdate = null;

    public SoftwareUpdateChecker(SoftwareType local, SoftwareType remote, UpdaterController updaterController) {
        this.local = local;
        this.remote = remote;
        this.updaterController = updaterController;
        this.compared = this.compare(local.getVersion(), remote.getVersion());
    }

    @Override
    public boolean isRemoteNewer() {
        return this.compared < 0;
    }

    @Override
    public boolean shouldUpdate() {
        if (this.mustUpdate()) {
            return true;
        }
        if (!this.isRemoteNewer()) {
            return false;
        }
        if (this.shouldUpdate == null) {
            UpdaterController.ShouldUpdateResult result = this.updaterController.softwareAvailable(this.local, this.remote);
            this.shouldUpdate = result == UpdaterController.ShouldUpdateResult.LOAD;
        }
        return this.shouldUpdate;
    }

    @Override
    public boolean mustUpdate() {
        if (this.local.getMainClass() == null) {
            return true;
        }
        return this.isRemoteNewer() && this.remote.isMandatory();
    }
}

