/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.checking;

import com.sun.istack.Nullable;
import de.governikus.updater.Logger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface UpdateChecker {
    public static final String SNAPSHOT_VERSION = "snapshot";

    public boolean isRemoteNewer();

    public boolean shouldUpdate();

    public boolean mustUpdate();

    default public int compare(String version1, String version2) {
        Integer nullCompared = this.compareNull(version1, version2);
        if (nullCompared != null) {
            return nullCompared;
        }
        Integer snapshotCompared = this.compareSnapshot(version1, version2);
        if (snapshotCompared != null) {
            return snapshotCompared;
        }
        Pattern snapshotPattern = Pattern.compile("^([\\d.]+)-SNAPSHOT$");
        Matcher matcher1 = snapshotPattern.matcher(version1);
        Matcher matcher2 = snapshotPattern.matcher(version2);
        boolean snapshot1 = matcher1.matches();
        boolean snapshot2 = matcher2.matches();
        if (snapshot1) {
            version1 = matcher1.group(1);
        }
        if (snapshot2) {
            version2 = matcher2.group(1);
        }
        String[] split1 = version1.split("\\.");
        String[] split2 = version2.split("\\.");
        for (int i = 0; i < Integer.max(split1.length, split2.length); ++i) {
            int v2;
            int v1 = split1.length > i && split1[i].matches("^\\d+$") ? Integer.parseInt(split1[i]) : -1;
            int compared = Integer.compare(v1, v2 = split2.length > i && split2[i].matches("^\\d+$") ? Integer.parseInt(split2[i]) : -1);
            if (compared != 0) {
                return compared;
            }
            if (v1 != -1 || v2 != -1) continue;
            return 0;
        }
        return Boolean.compare(snapshot2, snapshot1);
    }

    @Nullable
    private Integer compareNull(String version1, String version2) {
        if (version1 == null) {
            if (version2 == null) {
                Logger.error((String)"Both versions are null. Returning 0");
                return 0;
            }
            Logger.error((String)"version1 is null. Setting this as less");
            return -1;
        }
        if (version2 == null) {
            Logger.error((String)"version2 is null. Setting this as less");
            return 1;
        }
        return null;
    }

    @Nullable
    private Integer compareSnapshot(String version1, String version2) {
        if (Objects.equals(version1, SNAPSHOT_VERSION)) {
            if (Objects.equals(version2, SNAPSHOT_VERSION)) {
                return 0;
            }
            return 1;
        }
        if (Objects.equals(version2, SNAPSHOT_VERSION)) {
            return -1;
        }
        return null;
    }
}

