/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.InstallationType;
import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.SoftwareType;
import de.governikus.updater.Step;
import de.governikus.updater.Utils;
import de.governikus.updater.client.ProgressListener;
import de.governikus.updater.client.PropertiesManager;
import de.governikus.updater.client.Updater;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.gui.ErrorDialog;
import de.governikus.updater.client.gui.InstallerUpdateDialog;
import de.governikus.updater.client.gui.NettingsDialog;
import de.governikus.updater.client.gui.ProgressView;
import de.governikus.updater.client.gui.SoftwareAvailableDialog;
import de.governikus.updater.utils.SystemEnvironment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class DefaultGUIUpdateController
implements UpdaterController,
ProgressListener {
    protected Throwable cause;
    protected JFrame frame;
    protected PController progressController;
    protected final Updater updater;
    protected final File lockfile;
    private static final String[] MEASUREMENT = new String[]{"byte(s)", "kB", "MB", "GB", "TB"};

    public DefaultGUIUpdateController(Updater upd) {
        this.updater = upd;
        this.lockfile = upd.getLocalAppFolder().resolve("STARTLOCK").toFile();
    }

    protected DefaultGUIUpdateController(Updater upd, File lf) {
        this.updater = upd;
        this.lockfile = lf;
    }

    @Override
    public void started() {
        DefaultGUIUpdateController.prepareUIManager();
        this.progressController = new PController(this.updater.getAppName());
        this.showFrame(this.updater.getAppName());
    }

    @Override
    public String getUpdateFilename() {
        Logger.debug((String)"");
        return null;
    }

    @Override
    public void will(Step step) {
        this.progressController.step(step);
        if (step == Step.LOAD) {
            this.progressController.showLoad();
        }
    }

    @Override
    public void did(Step step) {
        if (step == Step.LOAD) {
            this.progressController.hideLoad();
        }
    }

    @Override
    public void progress(Step step, long current, long count) {
        if (step == Step.LOAD) {
            this.progressController.adjustProgressBytes(current, count);
        } else if (step == Step.CHECK_LOCAL || step == Step.COPY || step == Step.VERIFY) {
            this.progressController.adjustProgressWhole(current, count);
        }
    }

    @Override
    public void finished() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        if (this.cause != null) {
            Logger.debug((Throwable)this.cause);
        }
    }

    @Override
    public void errored(Throwable t, URI uri) {
        List<Proxy> select;
        this.cause = t;
        if (uri != null && uri.getHost() != null && (select = ProxySelector.getDefault().select(uri)) != null && !select.isEmpty()) {
            new ErrorDialog(this.frame, this.cause, select.get(0), false);
            return;
        }
        new ErrorDialog(this.frame, this.cause, null, false);
    }

    @Override
    public UpdaterController.NoRemoteProjectResult errorNoRemoteProject(IOException ioe, boolean couldRunLocal, URI uri) {
        this.cause = ioe;
        List<Proxy> select = ProxySelector.getDefault().select(uri);
        int result = select != null && !select.isEmpty() ? new ErrorDialog(this.frame, this.cause, select.get(0), couldRunLocal).getResult() : new ErrorDialog(this.frame, this.cause, null, couldRunLocal).getResult();
        if (result == 0) {
            this.cause = null;
            return UpdaterController.NoRemoteProjectResult.RUN_LOCAL;
        }
        return UpdaterController.NoRemoteProjectResult.QUIT;
    }

    @Override
    public boolean errorLoadingRemoteProject(IOException ioe, boolean couldRunLocal, URI uri) {
        this.cause = ioe;
        List<Proxy> select = ProxySelector.getDefault().select(uri);
        int result = select != null && !select.isEmpty() ? new ErrorDialog(this.frame, this.cause, select.get(0), couldRunLocal).getResult() : new ErrorDialog(this.frame, this.cause, null, couldRunLocal).getResult();
        if (result == 0) {
            this.cause = null;
            return true;
        }
        return false;
    }

    @Override
    public void upToDate() {
    }

    @Override
    public UpdaterController.ShouldUpdateResult softwareAvailable(SoftwareType local, SoftwareType remote) {
        return new SoftwareAvailableDialog(this.frame, this.updater.getAppName(), local.getVersion(), remote.getVersion()).getResult();
    }

    @Override
    public boolean useSystemNettings() {
        return true;
    }

    @Override
    public PasswordAuthentication getUsernameAndPassword(String scheme, Authenticator.RequestorType requestorType, String host, int port, URL url, String prompt) {
        if (SystemEnvironment.currentOSType() == OSType.LINUX) {
            String savedHost = PropertiesManager.getAppInstance().getProperty("proxy.host", null);
            String savedPort = PropertiesManager.getAppInstance().getProperty("proxy.port", null);
            String savedUser = PropertiesManager.getAppInstance().getProperty("proxy.userName", null);
            String savedPassword = PropertiesManager.getAppInstance().getProperty("proxy.password", null);
            if (host.equals(savedHost) && port == Integer.parseInt(savedPort) && savedUser != null && !savedUser.isEmpty() && savedPassword != null && !savedPassword.isEmpty()) {
                return new PasswordAuthentication(savedUser, savedPassword.toCharArray());
            }
        }
        DefaultGUIUpdateController.prepareUIManager();
        NettingsDialog dialog = new NettingsDialog(this.frame);
        dialog.init(scheme, requestorType, host, port, url, prompt);
        dialog.setVisible(true);
        int result = dialog.getResult();
        if (result != 0) {
            return null;
        }
        return new PasswordAuthentication(dialog.getUser(), dialog.getPassword());
    }

    protected void showFrame(String appName) {
        if (this.frame != null) {
            return;
        }
        this.frame = new JFrame(appName);
        this.frame.setUndecorated(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.016.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.024.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.032.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.048.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.064.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.096.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.128.png")));
        icons.add(tk.createImage(DefaultGUIUpdateController.class.getResource(DefaultGUIUpdateController.getIconPackage() + "bosKG_logo.256.png")));
        this.frame.setIconImages(icons);
        this.frame.setDefaultCloseOperation(0);
        JComponent contentPane = (JComponent)this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.progressController.getView(), "Center");
        this.frame.pack();
        this.frame.setSize(300, this.frame.getHeight());
        this.frame.setLocationRelativeTo(null);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private static void prepareUIManager() {
        if (!UIManager.getLookAndFeel().getName().equals(UIManager.getSystemLookAndFeelClassName())) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String reduceToReadable(long byteCount) {
        int stepCount;
        double result = byteCount;
        double stepSize = 1024.0;
        for (stepCount = 0; result > stepSize && stepCount < MEASUREMENT.length; result /= stepSize, ++stepCount) {
        }
        DecimalFormat df = new DecimalFormat("0.0");
        return df.format(result) + " " + MEASUREMENT[stepCount];
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this;
    }

    @Override
    public void lock() {
        Logger.info((String)("Lock file: " + this.lockfile.getAbsolutePath()));
        try {
            Utils.lock((File)this.lockfile);
        }
        catch (IOException e) {
            Logger.error((String)"", (Throwable)e);
        }
    }

    @Override
    public boolean isLocked() {
        Logger.info((String)("Lock file: " + this.lockfile.getAbsolutePath()));
        return Utils.isLocked((File)this.lockfile);
    }

    @Override
    public void unlock() {
        Logger.info((String)("Lock file: " + this.lockfile.getAbsolutePath()));
        Utils.unlock((File)this.lockfile);
    }

    @Override
    public boolean storeArgumentsForAlreadyStartedApp(String[] args) {
        return false;
    }

    @Override
    public String[] processParameters(String[] args) {
        return args;
    }

    @Override
    public UpdaterController.ShouldReInstallResult installerAvailable(InstallationType local, InstallationType remote) {
        return new InstallerUpdateDialog(this.frame, this.updater.getAppName(), local, remote, false).getResult();
    }

    @Override
    public UpdaterController.ShouldReInstallResult installerMandatory(InstallationType local, InstallationType remote) {
        return new InstallerUpdateDialog(this.frame, this.updater.getAppName(), local, remote, true).getResult();
    }

    public static String getIconPackage() {
        Object path = "/" + DefaultGUIUpdateController.class.getName().replace('.', '/');
        path = ((String)path).substring(0, ((String)path).lastIndexOf("/"));
        path = (String)path + "/images/";
        return path;
    }

    @Override
    public void quit() {
        if (this.frame != null) {
            final Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    DefaultGUIUpdateController.this.frame.setVisible(false);
                    DefaultGUIUpdateController.this.frame.dispose();
                    t.cancel();
                }
            }, 2000L);
        }
    }

    @Override
    public boolean resetProxySelector() {
        return false;
    }

    protected static class PController {
        ProgressView pv;
        Step currentStep;

        public PController(String label) {
            this.pv = new ProgressView(label);
            this.pv.adjust(0, Step.values().length);
        }

        public void hideLoad() {
            this.pv.setDisplay(null);
        }

        public void showLoad() {
            this.pv.setDisplay(Step.LOAD.getLabel() + " ...");
        }

        public void adjustProgressBytes(long r, long count) {
            String s = this.currentStep.getLabel() + " ... " + DefaultGUIUpdateController.reduceToReadable(r) + " / " + DefaultGUIUpdateController.reduceToReadable(count);
            this.pv.setDisplay(s);
        }

        public void adjustProgressWhole(long r, long count) {
            String s = this.currentStep.getLabel() + " ... " + r + " / " + count;
            this.pv.setDisplay(s);
        }

        public void step(Step step) {
            this.currentStep = step;
            this.pv.adjust(step.ordinal() + 1, Step.values().length);
            this.pv.setDisplay(step.getLabel());
        }

        public Component getView() {
            return this.pv;
        }
    }
}

