/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.client.PropertiesManager;
import de.governikus.updater.client.gui.NettingsProxyDialog;
import de.governikus.updater.client.gui.ProgressView;
import de.governikus.updater.utils.SystemEnvironment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String HIDE_ERROR_DIALOG_TIME = "hidedialogdate";
    private static final ResourceBundle res = ResourceBundle.getBundle(ErrorDialog.class.getName());
    private JButton quit;
    private JButton offline;
    private int result;
    private final boolean couldRunLocal;
    private boolean showInternetOptions;
    private JCheckBox checkbox;

    public ErrorDialog(JFrame parent, Throwable cause, Proxy proxy, boolean crl) {
        super((Frame)parent, true);
        if (this.runningOffline()) {
            this.couldRunLocal = true;
            this.closeDialog(0);
        } else {
            JComponent content = (JComponent)this.getContentPane();
            content.setBorder(new ProgressView.ButtonBorder());
            content.setLayout(new BorderLayout());
            this.couldRunLocal = crl;
            content.add((Component)this.prepareIconView(), "West");
            content.add((Component)this.prepareInfoView(), "North");
            content.add((Component)this.prepareContentView(cause, proxy), "Center");
            content.add((Component)this.prepareOperationsView(), "South");
            this.prepareFrame();
            if (this.couldRunLocal) {
                this.offline.requestFocus();
            } else {
                this.quit.requestFocus();
            }
            this.setVisible(true);
        }
    }

    private boolean runningOffline() {
        String hideErrorDialogTime = PropertiesManager.getAppInstance().getProperty(HIDE_ERROR_DIALOG_TIME, null);
        if (hideErrorDialogTime != null) {
            try {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                LocalDate period = LocalDate.parse(new String(Base64.getDecoder().decode(hideErrorDialogTime)), dtf);
                LocalDate today = LocalDate.now();
                int days = period.until(today).getDays();
                if (days >= 0 && days < 30) {
                    return true;
                }
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
        return false;
    }

    private JComponent prepareInfoView() {
        JPanel p = new JPanel(new FlowLayout(0, 6, 6));
        p.setOpaque(false);
        p.add(new JLabel(res.getString("error.label.info")));
        return p;
    }

    private JComponent prepareIconView() {
        JPanel p = new JPanel(new FlowLayout(2, 12, 12));
        p.setOpaque(false);
        JLabel icon = new JLabel();
        icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        p.add(icon);
        return p;
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new BorderLayout());
        operations.setOpaque(false);
        operations.add((Component)this.prepareCheckView(), "North");
        JPanel standards = new JPanel(new FlowLayout(2, 12, 12));
        standards.setOpaque(false);
        this.quit = new JButton(res.getString("error.button.quit"));
        this.quit.setOpaque(false);
        this.quit.addActionListener(e -> this.closeDialog(2));
        standards.add(this.quit);
        if (this.couldRunLocal) {
            this.offline = new JButton(res.getString("error.button.off"));
            this.offline.setOpaque(false);
            this.offline.addActionListener(e -> this.closeDialog(0));
            standards.add(this.offline);
        }
        operations.add((Component)standards, "Center");
        if (this.showInternetOptions) {
            JPanel miscellenious = new JPanel(new FlowLayout(0, 12, 12));
            miscellenious.setOpaque(false);
            JButton showNetOptions = new JButton();
            showNetOptions.setText(res.getString("error.button." + SystemEnvironment.currentOSType().value() + ".nettings"));
            showNetOptions.setOpaque(false);
            showNetOptions.addActionListener(e -> {
                if (SystemEnvironment.currentOSType() == OSType.WINDOWS) {
                    try {
                        Runtime.getRuntime().exec("rundll32.exe shell32.dll,Control_RunDLL inetcpl.cpl,,4");
                    }
                    catch (IOException e1) {
                        Logger.debug((String)"", (Throwable)e1);
                    }
                } else if (SystemEnvironment.currentOSType() == OSType.LINUX) {
                    NettingsProxyDialog d = new NettingsProxyDialog(this);
                    d.setVisible(true);
                } else if (SystemEnvironment.currentOSType() == OSType.MAC) {
                    String[] args = new String[]{"open", "/System/Library/PreferencePanes/Network.prefPane/"};
                    try {
                        Runtime.getRuntime().exec(args);
                    }
                    catch (IOException e1) {
                        Logger.debug((Throwable)e1);
                    }
                }
            });
            miscellenious.add(showNetOptions);
            operations.add((Component)miscellenious, "West");
        }
        return operations;
    }

    private JComponent prepareCheckView() {
        JPanel p = new JPanel(new FlowLayout(0, 6, 6));
        p.setOpaque(false);
        this.checkbox = new JCheckBox(res.getString("error.checkbox.text"));
        this.checkbox.setOpaque(false);
        p.add(this.checkbox);
        return p;
    }

    private JComponent prepareContentView(Throwable cause, Proxy proxy) {
        StringBuilder text = new StringBuilder();
        if (cause.getMessage() == null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            pw.flush();
            text.append(sw);
        } else {
            text.append(cause.getMessage());
        }
        JTextPane tp = new JTextPane();
        tp.setText(text.toString());
        tp.setEditable(false);
        tp.setOpaque(false);
        JScrollPane scroller = new JScrollPane(tp, 22, 30);
        scroller.setOpaque(false);
        scroller.getViewport().setOpaque(false);
        scroller.setPreferredSize(new Dimension(400, 150));
        if (!(cause instanceof IOException) || cause instanceof FileNotFoundException) {
            this.showInternetOptions = false;
            return scroller;
        }
        this.showInternetOptions = true;
        text.append('\n');
        text.append('\n');
        text.append(res.getString("error.io.message"));
        if (proxy != null) {
            text.append('\n');
            text.append(res.getString("error.io.proxy.message"));
            text.append('\n');
            text.append(res.getString("error.io.proxytype").replace("XXX", proxy.type().name()));
            text.append('\n');
            if (proxy.address() != null) {
                text.append(res.getString("error.io.address").replace("XXX", proxy.address().toString()));
                text.append('\n');
            }
        }
        text.append('\n');
        text.append(res.getString("error.io.fazit"));
        tp.setText(text.toString());
        return scroller;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(res.getString("error.title"));
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(2), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ErrorDialog.this.closeDialog(2);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        if (this.couldRunLocal) {
            this.getRootPane().setDefaultButton(this.offline);
        } else {
            this.getRootPane().setDefaultButton(this.quit);
        }
    }

    protected void closeDialog(int r) {
        if (this.checkbox != null) {
            PropertiesManager properties = PropertiesManager.getAppInstance();
            if (this.checkbox.isSelected()) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                properties.put(HIDE_ERROR_DIALOG_TIME, Base64.getEncoder().encodeToString(LocalDate.now().format(dtf).getBytes()));
            } else {
                properties.remove(HIDE_ERROR_DIALOG_TIME);
            }
        }
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }
}

