/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.InstallationType;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.gui.ProgressView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;

public class InstallerUpdateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle resources = ResourceBundle.getBundle(InstallerUpdateDialog.class.getName());
    private JButton no;
    private JButton yes;
    private UpdaterController.ShouldReInstallResult result;
    private final String appName;
    private final boolean mandatory;
    private final transient InstallationType local;
    private final transient InstallationType remote;

    public InstallerUpdateDialog(JFrame parent, String appName, InstallationType local, InstallationType remote, boolean mandatory) {
        super((Frame)parent, true);
        this.appName = appName;
        this.local = local;
        this.remote = remote;
        this.mandatory = mandatory;
        JComponent content = (JComponent)this.getContentPane();
        content.setBorder(new ProgressView.ButtonBorder());
        content.setLayout(new BorderLayout());
        content.add((Component)this.prepareIconView(), "West");
        content.add((Component)this.prepareContentView(), "Center");
        content.add((Component)this.prepareOperationsView(), "South");
        this.prepareFrame();
        (mandatory ? this.yes : this.no).requestFocus();
        SwingUtilities.invokeLater(() -> this.getRootPane().setDefaultButton(this.yes));
        this.setVisible(true);
    }

    private JComponent prepareIconView() {
        JPanel p = new JPanel(new FlowLayout(2, 12, 12));
        p.setOpaque(false);
        JLabel icon = new JLabel();
        icon.setIcon(UIManager.getIcon(this.mandatory ? "OptionPane.informationIcon" : "OptionPane.questionIcon"));
        p.add(icon);
        return p;
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new BorderLayout());
        operations.setOpaque(false);
        JPanel standards = new JPanel(new FlowLayout(2, 12, 12));
        standards.setOpaque(false);
        if (!this.mandatory) {
            this.no = new JButton(resources.getString("installer.available.button.no"));
            this.no.setDefaultCapable(false);
            this.no.setOpaque(false);
            this.no.addActionListener(e -> this.closeDialog(UpdaterController.ShouldReInstallResult.NOT_YET));
            standards.add(this.no);
        }
        this.yes = new JButton(resources.getString("installer.available.button.yes"));
        this.yes.setDefaultCapable(true);
        this.yes.setOpaque(false);
        this.yes.addActionListener(e -> this.closeDialog(UpdaterController.ShouldReInstallResult.REINSTALL));
        standards.add(this.yes);
        operations.add(standards);
        return operations;
    }

    private JComponent prepareContentView() {
        String message;
        String htmlText = resources.getString("installer.available.message");
        if (this.local.getVersion() != null) {
            htmlText = htmlText.replace("LOCAL_VERSION", this.local.getVersion());
        }
        if (this.remote.getVersion() != null) {
            htmlText = htmlText.replace("REMOTE_VERSION", this.remote.getVersion());
        }
        if ((message = this.remote.getMessage()) != null) {
            htmlText = htmlText.replace("INFO_TEXT", "<p>" + message + "</p>");
        }
        String mandatoryText = this.mandatory ? "" : "<br/>" + resources.getString("installer.available.question");
        htmlText = htmlText.replace("MANDATORY_TEXT", mandatoryText);
        return InstallerUpdateDialog.getHtmlViewer(htmlText);
    }

    private static JEditorPane getHtmlViewer(String htmlText) {
        JEditorPane pane = new JEditorPane("text/html", htmlText);
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                pane.setToolTipText(hyperlinkEvent.getDescription());
            } else if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                pane.setToolTipText(null);
            } else if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        });
        return pane;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(this.appName);
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(UpdaterController.ShouldReInstallResult.REINSTALL), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InstallerUpdateDialog.this.closeDialog(UpdaterController.ShouldReInstallResult.REINSTALL);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.no);
    }

    protected void closeDialog(UpdaterController.ShouldReInstallResult r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public UpdaterController.ShouldReInstallResult getResult() {
        return this.result;
    }
}

