/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.client.gui.ProgressView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NettingsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle res = ResourceBundle.getBundle(NettingsDialog.class.getName());
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final Insets NORM = new Insets(12, 12, 12, 12);
    private static final Insets RIGHT = new Insets(12, 6, 12, 12);
    private static final Insets LEFT = new Insets(12, 12, 12, 6);
    private int result = 2;
    private JButton ok;
    private JTextField userName;
    private JPasswordField password;

    public NettingsDialog() {
    }

    public NettingsDialog(Frame owner) {
        super(owner, true);
    }

    public NettingsDialog(Dialog owner) {
        super(owner, true);
    }

    public void init(String schema, Authenticator.RequestorType type, String host, int port, URL url, String prompt) {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBackground(Color.WHITE);
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new ProgressView.ButtonBorder());
        int y = 0;
        JComponent p = this.prepareDescriptionView(schema, type, host, port, url, prompt);
        contentPane.add((Component)p, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareInputView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareOperationsView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        this.prepareFrame();
        this.userName.requestFocusInWindow();
    }

    private JComponent prepareDescriptionView(String schema, Authenticator.RequestorType type, String host, int port, URL url, String prompt) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        StringBuilder sb = new StringBuilder();
        String s = res.getString("hint.general");
        s = s.replace("SCHEMA", schema);
        s = s.replace("TYPE", type.name());
        s = s.replace("HOST", host);
        s = s.replace("PORT", Integer.toString(port));
        s = s.replace("URL", url.toString());
        sb.append(s);
        sb.append((String)(prompt == null || prompt.isEmpty() ? "" : "\n\n" + prompt));
        if ("ntlm".equals(schema)) {
            sb.append("\n\n");
            sb.append(res.getString("hint.ntlm"));
        }
        JTextPane l = new JTextPane();
        l.setText(sb.toString());
        l.setOpaque(false);
        l.setEditable(false);
        p.add((Component)l, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, NORM, 0, 0));
        return p;
    }

    private JComponent prepareInputView() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        int y = 0;
        JLabel l = new JLabel(res.getString("userName.label"));
        p.add((Component)l, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.userName = new JTextField();
        DocumentListener userNameDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsDialog.this.userNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsDialog.this.userNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.userName.getDocument().addDocumentListener(userNameDL);
        this.userName.setColumns(25);
        p.add((Component)this.userName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("password.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.password = new JPasswordField();
        DocumentListener passwordDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsDialog.this.passwordChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsDialog.this.passwordChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.password.getDocument().addDocumentListener(passwordDL);
        this.password.setColumns(25);
        p.add((Component)this.password, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        return p;
    }

    private void checkOK() {
        boolean b = this.userName.getDocument().getLength() > 0;
        b = b && this.password.getDocument().getLength() > 0;
        this.ok.setEnabled(b);
    }

    protected void passwordChanged() {
        this.checkOK();
    }

    protected void userNameChanged() {
        this.checkOK();
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new FlowLayout(2, 12, 12));
        operations.setOpaque(false);
        this.ok = new JButton(res.getString("button.ok.label"));
        this.ok.setDefaultCapable(true);
        this.ok.setOpaque(false);
        this.ok.setEnabled(false);
        this.ok.addActionListener(e -> this.closeDialog(0));
        operations.add(this.ok);
        JButton cancel = new JButton(res.getString("button.cancel.label"));
        cancel.setDefaultCapable(false);
        cancel.setOpaque(false);
        cancel.addActionListener(e -> this.closeDialog(2));
        operations.add(cancel);
        return operations;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(res.getString("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(2), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NettingsDialog.this.closeDialog(2);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.ok);
    }

    protected void closeDialog(int r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public String getUser() {
        return this.userName.getText();
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }
}

