/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.client.PropertiesManager;
import de.governikus.updater.client.gui.ProgressView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NettingsProxyDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle res = ResourceBundle.getBundle(NettingsProxyDialog.class.getName());
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private static final Insets RIGHT = new Insets(12, 6, 12, 12);
    private static final Insets LEFT = new Insets(12, 12, 12, 6);
    private int result = 2;
    private JButton ok;
    private JTextField host;
    private JTextField port;
    private JTextField userName;
    private JPasswordField password;

    public NettingsProxyDialog(Frame owner) {
        super(owner, true);
        this.init();
    }

    public NettingsProxyDialog(Dialog owner) {
        super(owner, true);
        this.init();
    }

    private void init() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBackground(Color.WHITE);
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(new ProgressView.ButtonBorder());
        int y = 0;
        JComponent p = this.prepareDescriptionView();
        contentPane.add((Component)p, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareInputView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        p = this.prepareOperationsView();
        contentPane.add((Component)p, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 18, 2, ZERO, 0, 0));
        this.host.setText(PropertiesManager.getAppInstance().getProperty("proxy.host", null));
        this.port.setText(PropertiesManager.getAppInstance().getProperty("proxy.port", null));
        this.userName.setText(PropertiesManager.getAppInstance().getProperty("proxy.userName", null));
        this.password.setText(PropertiesManager.getAppInstance().getProperty("proxy.password", null));
        this.prepareFrame();
        this.host.requestFocusInWindow();
        this.host.selectAll();
    }

    private JComponent prepareDescriptionView() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        return p;
    }

    private JComponent prepareInputView() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        int y = 0;
        JLabel l = new JLabel(res.getString("host.label"));
        p.add((Component)l, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.host = new JTextField();
        DocumentListener hostDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.hostChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.hostChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.host.getDocument().addDocumentListener(hostDL);
        this.host.setColumns(25);
        p.add((Component)this.host, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("port.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.port = new JTextField();
        DocumentListener portDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.portChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.portChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.port.getDocument().addDocumentListener(portDL);
        this.port.setColumns(4);
        p.add((Component)this.port, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("userName.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.userName = new JTextField();
        DocumentListener userNameDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.userNameChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.userNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.userName.getDocument().addDocumentListener(userNameDL);
        this.userName.setColumns(25);
        p.add((Component)this.userName, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        l = new JLabel(res.getString("password.label"));
        p.add((Component)l, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, LEFT, 0, 0));
        this.password = new JPasswordField();
        DocumentListener passwordDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.passwordChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NettingsProxyDialog.this.passwordChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.password.getDocument().addDocumentListener(passwordDL);
        this.password.setColumns(25);
        p.add((Component)this.password, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, RIGHT, 0, 0));
        return p;
    }

    private void checkOK() {
        boolean b = this.host.getDocument().getLength() > 0;
        boolean bl = b = b && this.port.getDocument().getLength() == 4;
        if (b && this.userName.getDocument().getLength() > 0 || this.userName.getDocument().getLength() > 0) {
            boolean bl2 = b = this.userName.getDocument().getLength() > 0 && this.password.getDocument().getLength() > 0;
        }
        if (!b) {
            b = this.host.getDocument().getLength() == 0 && this.port.getDocument().getLength() == 0 && this.userName.getDocument().getLength() == 0 && this.password.getDocument().getLength() == 0;
        }
        this.ok.setEnabled(b);
    }

    protected void hostChanged() {
        this.checkOK();
    }

    protected void portChanged() {
        this.checkOK();
    }

    protected void userNameChanged() {
        this.checkOK();
    }

    protected void passwordChanged() {
        this.checkOK();
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new FlowLayout(2, 12, 12));
        operations.setOpaque(false);
        this.ok = new JButton(res.getString("button.ok.label"));
        this.ok.setDefaultCapable(true);
        this.ok.setOpaque(false);
        this.ok.setEnabled(false);
        this.ok.addActionListener(e -> this.closeDialog(0));
        operations.add(this.ok);
        JButton cancel = new JButton(res.getString("button.cancel.label"));
        cancel.setDefaultCapable(false);
        cancel.setOpaque(false);
        cancel.addActionListener(e -> this.closeDialog(2));
        operations.add(cancel);
        return operations;
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(res.getString("dialog.title"));
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(2), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NettingsProxyDialog.this.closeDialog(2);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.ok);
    }

    protected void closeDialog(int r) {
        this.result = r;
        if (this.result == 0) {
            PropertiesManager.getAppInstance().put("proxy.host", this.host.getText());
            PropertiesManager.getAppInstance().put("proxy.port", this.port.getText());
            PropertiesManager.getAppInstance().put("proxy.userName", this.userName.getText());
            PropertiesManager.getAppInstance().put("proxy.password", new String(this.password.getPassword()));
        }
        this.setVisible(false);
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public String getHost() {
        return this.host.getText();
    }

    public String getPort() {
        return this.port.getText();
    }

    public String getUser() {
        return this.userName.getText();
    }

    public String getPassword() {
        char[] cc = this.password.getPassword();
        return new String(cc);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettingsProxyDialog d = new NettingsProxyDialog(new JFrame());
        d.setVisible(true);
        System.out.println("result: " + d.getResult());
        System.out.println("    host: " + d.getHost());
        System.out.println("    port: " + d.getPort());
        System.out.println("username: " + d.getUser());
        System.exit(0);
    }
}

