/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ProgressBarUI;

public class ProgressView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JProgressBar progressBar;
    private final JLabel progressLabel;
    private final JLabel display;

    public ProgressView(String l) {
        this.setLayout(new BorderLayout(3, 3));
        this.setBorder(new ButtonBorder());
        JPanel label = new JPanel(new BorderLayout(6, 0));
        label.setOpaque(false);
        JLabel progressTitle = new JLabel();
        progressTitle.setText(l);
        progressTitle.setForeground(Color.DARK_GRAY);
        label.add((Component)progressTitle, "West");
        this.progressLabel = new JLabel();
        this.progressLabel.setForeground(Color.DARK_GRAY);
        label.add((Component)this.progressLabel, "Center");
        this.add((Component)label, "North");
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(-1, 12));
        this.progressBar.setUI(new IOSProgressBarUI());
        this.add((Component)this.progressBar, "Center");
        this.display = new JLabel();
        this.display.setText(" ");
        this.display.setForeground(Color.DARK_GRAY);
        this.add((Component)this.display, "South");
        this.setVisible(false);
    }

    public void cleanup() {
        this.progressBar.getModel().setRangeProperties(0, 0, 0, 0, false);
        this.progressBar.setIndeterminate(false);
        this.repaint();
    }

    public void adjust(int current, int count) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.getModel().setRangeProperties(current, 1, this.progressBar.getMinimum(), count, false);
        this.progressBar.setIndeterminate(count == 0);
        if (count > 0) {
            int value = Math.min(this.progressBar.getValue(), this.progressBar.getMaximum());
            this.progressLabel.setText("(" + value + " / " + this.progressBar.getMaximum() + ")");
        } else {
            this.progressLabel.setText(null);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.repaint();
    }

    public void setDisplay(String s) {
        if (s == null) {
            s = " ";
        }
        this.display.setText(s);
    }

    public static class ButtonBorder
    implements Border {
        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(12, 12, 13, 12);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics graph, int x, int y, int w, int h) {
            Graphics2D g = (Graphics2D)graph;
            g.setPaint(new GradientPaint(x, y, new Color(247, 247, 247), x, (float)y + (float)h, new Color(230, 230, 230)));
            g.fillRect(x, y, w, h);
            g.setColor(new Color(192, 192, 192));
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        }
    }

    public static class IOSProgressBarUI
    extends ProgressBarUI {
        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            c.setBorder(new EmptyBorder(0, 0, 0, 0));
            Dimension d = c.getPreferredSize();
            d.height = 8;
            c.setPreferredSize(d);
        }

        @Override
        public void update(Graphics g, JComponent c) {
            this.paint(g, c);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JProgressBar pb = (JProgressBar)c;
            BoundedRangeModel model = pb.getModel();
            if (model.getMaximum() - model.getMinimum() != 0) {
                float w = pb.getWidth();
                float h = pb.getHeight();
                float len = (float)((double)w * pb.getPercentComplete());
                Area a = new Area();
                a.add(new Area(new RoundRectangle2D.Float(0.0f, 0.0f, w - 1.0f, h - 1.0f, h, h)));
                a.subtract(new Area(new RoundRectangle2D.Float(2.0f, 2.0f, w - 5.0f, h - 5.0f, h - 2.0f, h - 2.0f)));
                a.add(new Area(new RoundRectangle2D.Float(2.0f, 2.0f, h - 5.0f, h - 5.0f, h - 2.0f, h - 2.0f)));
                a.add(new Area(new Rectangle2D.Float(h / 2.0f, 2.0f, len - h / 2.0f - 3.0f, h - 5.0f)));
                g2.setColor(new Color(Integer.MIN_VALUE, true));
                g2.fill(a);
            }
        }
    }
}

