/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.gui;

import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.gui.ProgressView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SoftwareAvailableDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle res = ResourceBundle.getBundle(SoftwareAvailableDialog.class.getName());
    private JButton no;
    private JButton yes;
    private UpdaterController.ShouldUpdateResult result;
    private final String messageKey;
    private final String appName;
    private final String remoteVersion;
    private final String localVersion;

    public SoftwareAvailableDialog(JFrame parent, String an, String localVersion, String remoteVersion) {
        super((Frame)parent, true);
        this.appName = an;
        this.messageKey = "update.available";
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        JComponent content = (JComponent)this.getContentPane();
        content.setBorder(new ProgressView.ButtonBorder());
        content.setLayout(new BorderLayout());
        content.add((Component)this.prepareIconView(), "West");
        content.add((Component)this.prepareContentView(), "Center");
        content.add((Component)this.prepareOperationsView(), "South");
        this.prepareFrame();
        this.no.requestFocus();
        SwingUtilities.invokeLater(() -> this.getRootPane().setDefaultButton(this.yes));
        this.setVisible(true);
    }

    private JComponent prepareIconView() {
        JPanel p = new JPanel(new FlowLayout(2, 12, 12));
        p.setOpaque(false);
        JLabel icon = new JLabel();
        icon.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        p.add(icon);
        return p;
    }

    private JComponent prepareOperationsView() {
        JPanel operations = new JPanel(new BorderLayout());
        operations.setOpaque(false);
        JPanel standards = new JPanel(new FlowLayout(2, 12, 12));
        standards.setOpaque(false);
        this.no = new JButton(res.getString(this.messageKey + ".button.no"));
        this.no.setDefaultCapable(false);
        this.no.setOpaque(false);
        this.no.addActionListener(e -> this.closeDialog(UpdaterController.ShouldUpdateResult.RUN_LOCAL));
        standards.add(this.no);
        this.yes = new JButton(res.getString(this.messageKey + ".button.yes"));
        this.yes.setDefaultCapable(true);
        this.yes.setOpaque(false);
        this.yes.addActionListener(e -> this.closeDialog(UpdaterController.ShouldUpdateResult.LOAD));
        standards.add(this.yes);
        operations.add(standards);
        return operations;
    }

    private JComponent prepareContentView() {
        String s = res.getString(this.messageKey + ".message");
        s = s.replace("LOCAL_VERSION", Objects.toString(this.localVersion));
        s = s.replace("REMOTE_VERSION", Objects.toString(this.remoteVersion));
        return new JLabel(s);
    }

    private void prepareFrame() {
        this.setIconImages(((Window)this.getParent()).getIconImages());
        this.setTitle(this.appName);
        this.setDefaultCloseOperation(0);
        this.getRootPane().registerKeyboardAction(e -> this.closeDialog(UpdaterController.ShouldUpdateResult.RUN_LOCAL), KeyStroke.getKeyStroke(27, 0, false), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SoftwareAvailableDialog.this.closeDialog(UpdaterController.ShouldUpdateResult.RUN_LOCAL);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.no);
    }

    protected void closeDialog(UpdaterController.ShouldUpdateResult r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    public UpdaterController.ShouldUpdateResult getResult() {
        return this.result;
    }
}

