/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.proxy;

import de.governikus.updater.client.proxy.HostnameFilter;
import de.governikus.updater.client.proxy.IPv4WithSubnetChecker;
import de.governikus.updater.client.proxy.IpRangeFilter;
import de.governikus.updater.client.proxy.UriFilter;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractProxySelector
extends ProxySelector {
    public static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    List<UriFilter> result = new ArrayList<UriFilter>();

    public void parseProxyByPass(String proxyByPass) {
        if (proxyByPass != null) {
            String[] tokens;
            for (String token : tokens = proxyByPass.split("[,]+|[;]+")) {
                String tkn = token.trim();
                if (IPv4WithSubnetChecker.isValid(tkn)) {
                    this.result.add(new IpRangeFilter(tkn));
                    continue;
                }
                if (tkn.endsWith("*")) {
                    tkn = tkn.substring(0, tkn.length() - 1);
                    this.result.add(new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, tkn));
                    continue;
                }
                if (tkn.trim().startsWith("*")) {
                    tkn = tkn.substring(1);
                    this.result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
                    continue;
                }
                this.result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, tkn));
            }
        }
    }

    protected boolean proxyByPassFor(URI uri) {
        for (UriFilter filter : this.result) {
            if (!filter.accept(uri)) continue;
            return true;
        }
        return false;
    }
}

