/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.proxy;

import de.governikus.updater.Logger;
import de.governikus.updater.client.PropertiesManager;
import de.governikus.updater.client.proxy.ProxyConstants;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxProxySelector
extends ProxySelector {
    private static final List<Proxy> PROXYS = new ArrayList<Proxy>();
    private static final Pattern PROXY_PATTERN = Pattern.compile("(?:.+?//)?(.+?)(?::(\\d+)|$)");

    public LinuxProxySelector() {
        String pass;
        String user;
        boolean hasProxyEntry;
        Logger.info((String)"Trying to use LinuxProxySelector for proxy handling.");
        this.setProxyByEnvironment();
        String host = PropertiesManager.getAppInstance().getProperty("proxy.host", null);
        String port = PropertiesManager.getAppInstance().getProperty("proxy.port", null);
        boolean bl = hasProxyEntry = host != null && port != null;
        if (!hasProxyEntry) {
            PROXYS.add(Proxy.NO_PROXY);
            return;
        }
        PROXYS.add(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, Integer.parseInt(port))));
        System.setProperty(ProxyConstants.HTTP_PROXY_HOST.value(), host);
        System.setProperty(ProxyConstants.HTTPS_PROXY_HOST.value(), host);
        System.setProperty(ProxyConstants.HTTP_PROXY_PORT.value(), port);
        System.setProperty(ProxyConstants.HTTPS_PROXY_PORT.value(), port);
        Logger.info((String)("http.proxyHost: " + System.getProperty(ProxyConstants.HTTP_PROXY_HOST.value(), "")));
        Logger.info((String)("http.proxyPort: " + System.getProperty(ProxyConstants.HTTP_PROXY_PORT.value(), "")));
        String bypass = PropertiesManager.getAppInstance().getProperty("proxy.bypass", null);
        if (bypass != null && !bypass.isEmpty()) {
            String[] proxys;
            ArrayList<String> nonProxyHosts = new ArrayList<String>();
            for (String entry : proxys = bypass.split(",")) {
                if ("<local>".equals(entry) || "*.local".equals(entry)) {
                    nonProxyHosts.add("localhost");
                    continue;
                }
                nonProxyHosts.add(entry);
            }
            String propertyValue = String.join((CharSequence)"|", nonProxyHosts);
            System.setProperty(ProxyConstants.HTTP_NON_PROXY_HOSTS.value(), propertyValue);
            Logger.info((String)("http.nonProxyHosts: " + propertyValue));
        }
        if ((user = PropertiesManager.getAppInstance().getProperty("proxy.userName", null)) != null) {
            System.setProperty(ProxyConstants.HTTP_PROXY_USER.value(), user);
            System.setProperty(ProxyConstants.HTTPS_PROXY_USER.value(), user);
        }
        if ((pass = PropertiesManager.getAppInstance().getProperty("proxy.password", null)) != null) {
            System.setProperty(ProxyConstants.HTTP_PROXY_PASS.value(), pass);
            System.setProperty(ProxyConstants.HTTPS_PROXY_PASS.value(), pass);
        }
    }

    private void setProxyByEnvironment() {
        Logger.info((String)"Search for proxy environment variables...");
        String httpProxy = null;
        String httpsProxy = null;
        String noProxy = null;
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if ("http_proxy".equalsIgnoreCase(entry.getKey())) {
                httpProxy = env.get(entry.getKey());
                Logger.info((String)(entry.getKey() + "=" + httpProxy));
                continue;
            }
            if ("https_proxy".equalsIgnoreCase(entry.getValue())) {
                httpsProxy = env.get(entry.getKey());
                Logger.info((String)(entry.getKey() + "=" + httpsProxy));
                continue;
            }
            if (!"no_proxy".equalsIgnoreCase(entry.getValue())) continue;
            noProxy = env.get(entry.getKey());
            Logger.info((String)(entry.getKey() + "=" + noProxy));
        }
        if (httpProxy != null) {
            this.setProxyByEnvironment("http", httpProxy);
        }
        if (httpsProxy != null) {
            this.setProxyByEnvironment("https", httpsProxy);
        }
        if (noProxy != null) {
            PropertiesManager.getAppInstance().put("proxy.bypass", noProxy);
        }
    }

    private void setProxyByEnvironment(String prefix, String envValue) {
        if (prefix == null || envValue == null) {
            return;
        }
        Matcher m = PROXY_PATTERN.matcher(envValue);
        if (m.find()) {
            int beginIndex;
            String host = m.group(1);
            if (host == null) {
                return;
            }
            String port = m.group(2);
            if (port == null) {
                port = "80";
            }
            if ((beginIndex = host.indexOf("@")) >= 0) {
                String value = host.substring(0, beginIndex);
                host = host.substring(++beginIndex);
                beginIndex = value.indexOf(":");
                if (beginIndex >= 0) {
                    String userName = value.substring(0, beginIndex);
                    String password = value.substring(++beginIndex);
                    PropertiesManager.getAppInstance().put("proxy.userName", userName);
                    PropertiesManager.getAppInstance().put("proxy.password", password);
                }
            }
            PropertiesManager.getAppInstance().put("proxy.host", host);
            PropertiesManager.getAppInstance().put("proxy.port", port);
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        return PROXYS;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

