/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.proxy;

import de.governikus.updater.Logger;
import de.governikus.updater.client.Reg;
import de.governikus.updater.client.proxy.AbstractProxySelector;
import de.governikus.updater.client.proxy.ProxyConstants;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class WindowsProxySelector
extends AbstractProxySelector {
    private String host;
    private int port;
    private static final List<Proxy> PROXYS = new ArrayList<Proxy>();

    public WindowsProxySelector() {
        Logger.debug((String)"Trying to use WindowsProxySelector for proxy handling.");
        try {
            String[] split;
            String proxyEntry;
            boolean hasProxyEntry;
            String regPath = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
            String key = "ProxyEnable";
            List<Reg.Entry> entries = Reg.query(regPath, key);
            boolean bl = hasProxyEntry = !entries.isEmpty() && (Long)entries.get((int)0).value == 1L;
            if (!hasProxyEntry) {
                PROXYS.add(Proxy.NO_PROXY);
                return;
            }
            key = "ProxyServer";
            entries = Reg.query(regPath, key);
            String string = proxyEntry = !entries.isEmpty() ? (String)entries.get((int)0).value : null;
            if (proxyEntry == null) {
                if (PROXYS.contains(Proxy.NO_PROXY)) {
                    PROXYS.add(Proxy.NO_PROXY);
                }
                return;
            }
            for (String str : split = proxyEntry.split(";")) {
                if (!str.startsWith("http=")) continue;
                proxyEntry = str.substring("http=".length());
            }
            split = proxyEntry.split(":");
            this.host = split[0];
            if (split.length > 1) {
                this.port = Integer.parseInt(split[1]);
            }
            PROXYS.add(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.host, this.port)));
            key = "ProxyOverride";
            entries = Reg.query(regPath, key);
            String proxyOverrideEntry = !entries.isEmpty() ? (String)entries.get((int)0).value : null;
            this.parseProxyByPass(proxyOverrideEntry);
            System.setProperty(ProxyConstants.HTTP_PROXY_SET.value(), "true");
            if (this.host != null) {
                System.setProperty(ProxyConstants.HTTP_PROXY_HOST.value(), this.host);
                System.setProperty(ProxyConstants.HTTPS_PROXY_HOST.value(), this.host);
            }
            if (this.port != 0) {
                System.setProperty(ProxyConstants.HTTP_PROXY_PORT.value(), String.valueOf(this.port));
                System.setProperty(ProxyConstants.HTTPS_PROXY_PORT.value(), String.valueOf(this.port));
            }
            if (proxyOverrideEntry != null) {
                String[] hosts = proxyOverrideEntry.split(";");
                StringBuilder sb = new StringBuilder();
                for (String str : hosts) {
                    if ("<local>".equals(str) || "*.local".equals(str)) {
                        if (sb.length() != 0) {
                            sb.append('|');
                        }
                        sb.append("localhost");
                        continue;
                    }
                    if (sb.length() != 0) {
                        sb.append('|');
                    }
                    sb.append(str);
                }
                System.setProperty(ProxyConstants.HTTP_NON_PROXY_HOSTS.value(), sb.toString());
                System.setProperty(ProxyConstants.HTTPS_NON_PROXY_HOSTS.value(), sb.toString());
            }
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
            Logger.info((String)"Error parsing proxy from registry. Using direct connection");
        }
        catch (IOException | NumberFormatException ex) {
            Logger.info((String)"Error parsing proxy from registry. Using direct connection");
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.proxyByPassFor(uri)) {
            return NO_PROXY_LIST;
        }
        return PROXYS;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    public static void main(String[] args) throws Exception {
        String[] split;
        String proxyEntry = "http=proxy.rwe.com:8080;https=proxy.rwe.com:8080;ftp=proxy.rwe.com:8080";
        for (String str : split = proxyEntry.split(";")) {
            if (!str.startsWith("http=")) continue;
            proxyEntry = str.substring("http=".length());
        }
        split = proxyEntry.split(":");
        String host = split[0];
        System.err.println("\nhost: " + host);
        if (split.length > 1) {
            int port = Integer.parseInt(split[1]);
            System.err.println("\nport: " + port);
        }
    }
}

