/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.proxy.pac;

import de.governikus.updater.Logger;
import de.governikus.updater.client.Reg;
import de.governikus.updater.client.proxy.pac.PacScriptMethods;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

public class PacProxySelector
extends ProxySelector {
    private static final String PAC_SOCKS = Proxy.Type.SOCKS.name();
    private static final String PAC_DIRECT = Proxy.Type.DIRECT.name();
    private static final String SCRIPT_METHODS_OBJECT = "__pacutil";
    private static String pacScriptContent;
    private final Context context;

    public PacProxySelector() throws IOException {
        Logger.debug((String)"Trying to use PacProxySelector for proxy handling.");
        this.context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.EXPLICIT).option("engine.WarnInterpreterOnly", "false").build();
        PacProxySelector.setupEngine(this.context);
        try {
            String path;
            String regPath = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
            String key = "AutoConfigURL";
            List<Reg.Entry> pacEntries = Reg.query(regPath, key);
            String string = path = !pacEntries.isEmpty() ? (String)pacEntries.get((int)0).value : null;
            if (path == null) {
                throw new IOException("No pac file found");
            }
            pacScriptContent = PacProxySelector.readFile(path);
            System.setProperty("http.proxy.auto.config", path);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public PacProxySelector(String path) throws IOException {
        if (path == null) {
            throw new IOException("No pac file found");
        }
        this.context = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.EXPLICIT).option("engine.WarnInterpreterOnly", "false").build();
        PacProxySelector.setupEngine(this.context);
        try {
            pacScriptContent = PacProxySelector.readFile(path);
            System.setProperty("http.proxy.auto.config", path);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static HttpURLConnection setupHTTPConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        con.setInstanceFollowRedirects(true);
        con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig, */*;q=0.8");
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) throws IOException, URISyntaxException {
        InputStream is = null;
        HttpURLConnection con = null;
        try {
            if (((String)path).startsWith("file:/") || !((String)path).contains(":/")) {
                File file;
                if (!((String)path).contains(":/")) {
                    file = new File((String)path);
                } else {
                    try {
                        file = new File(new URL((String)path).toURI());
                    }
                    catch (IllegalArgumentException e) {
                        Logger.debug((String)("Proxy Auto Config url (" + (String)path + ") malformed. try to rewritting url."));
                        path = ((String)path).substring(6);
                        while (((String)path).indexOf(47) == 0) {
                            path = ((String)path).substring(1);
                        }
                        path = "file:/" + (String)path;
                        file = new File(new URL((String)path).toURI());
                    }
                }
                is = new FileInputStream(file);
            } else {
                URL url = new URL((String)path);
                con = PacProxySelector.setupHTTPConnection(url);
                if (con.getResponseCode() != 200) {
                    throw new IOException("Server returned: " + con.getResponseCode() + " " + con.getResponseMessage());
                }
                is = con.getInputStream();
            }
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            String string = baos.toString("ISO-8859-1");
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static void setupEngine(Context context) throws IOException {
        Method[] scriptMethods;
        context.getBindings("js").putMember(SCRIPT_METHODS_OBJECT, (Object)new PacScriptMethods());
        Class<PacScriptMethods> scriptMethodsClazz = PacScriptMethods.class;
        for (Method method : scriptMethods = scriptMethodsClazz.getMethods()) {
            int i;
            String name = method.getName();
            int args = method.getParameterTypes().length;
            StringBuilder toEval = new StringBuilder(name).append(" = function(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append(") {return ").append(SCRIPT_METHODS_OBJECT).append(".").append(name).append("(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append("); }");
            try {
                context.eval("js", (CharSequence)toEval.toString());
            }
            catch (PolyglotException e) {
                Logger.error((String)("JS evaluation error when creating alias for " + name + "."), (Throwable)e);
                throw new IOException("Error setting up script engine", e);
            }
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null.");
        }
        try {
            String[] proxyDefinitions;
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            String parseResult = this.evaluate(uri.toString(), uri.getHost());
            for (String proxyDef : proxyDefinitions = parseResult.split(";")) {
                if (proxyDef.isEmpty()) continue;
                proxies.add(this.buildProxyFromPacResult(proxyDef));
            }
            return proxies;
        }
        catch (IOException e) {
            Logger.error((String)("PAC resolving error (" + e.getCause().getMessage() + "). Using direct connection."));
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    public String evaluate(String url, String host) throws IOException {
        try {
            String script = pacScriptContent + "\n ;FindProxyForURL (\"" + url + "\",\"" + host + "\")";
            Value result = this.context.eval("js", (CharSequence)script);
            if (!result.isString()) {
                Logger.error((String)String.format("The PAC file returned a non-string value as the proxy for url %s, host %s. Using DIRECT proxy.", url, host));
                return "DIRECT";
            }
            String str = result.asString();
            Logger.info((String)str);
            return str;
        }
        catch (Exception e) {
            throw new IOException("Error while executing PAC script", e);
        }
    }

    private Proxy buildProxyFromPacResult(String pacResult) {
        if (pacResult == null || pacResult.trim().length() < 6) {
            return Proxy.NO_PROXY;
        }
        String proxyDef = pacResult.trim();
        if (proxyDef.toUpperCase().startsWith(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        Proxy.Type type = Proxy.Type.HTTP;
        if (proxyDef.toUpperCase().startsWith(PAC_SOCKS)) {
            type = Proxy.Type.SOCKS;
        }
        String host = proxyDef.substring(6);
        int port = 8080;
        int indexOfPort = host.indexOf(58);
        if (indexOfPort != -1) {
            port = Integer.parseInt(host.substring(indexOfPort + 1).trim());
            host = host.substring(0, indexOfPort).trim();
        }
        InetSocketAddress adr = InetSocketAddress.createUnresolved(host, port);
        return new Proxy(type, adr);
    }
}

