/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.client.security;

import com.sun.istack.Nullable;
import de.governikus.updater.ArtefactType;
import de.governikus.updater.Increasable;
import de.governikus.updater.Logger;
import de.governikus.updater.Project;
import de.governikus.updater.SystemPropertyKey;
import de.governikus.updater.client.ArtefactUpdater;
import de.governikus.updater.security.JarVerifier;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectVerifier {
    private final Path libsFolder;
    private final ConcurrentMap<String, Long> expectedFiles;
    private final Set<Path> unexpectedFiles = Collections.synchronizedSet(new HashSet());
    private final Set<String> missingArtefacts;
    private final Set<Path> extractedFiles = new HashSet<Path>();
    private final ExecutorService executorService;

    public ProjectVerifier(Project project, Path libsFolder) {
        this.libsFolder = libsFolder;
        this.expectedFiles = this.getExpectedArtefacts(project);
        Map<String, Long> inflatedFiles = this.getInflatedFilesFromArtefacts(project);
        this.expectedFiles.putAll(inflatedFiles);
        this.missingArtefacts = Collections.synchronizedSet(Stream.concat(project.getSoftware().getArtefacts().getArtefact().stream(), project.getConfiguration().getArtefacts().getArtefact().stream()).filter(artefactType -> Objects.isNull(artefactType.getFile())).map(ArtefactType::getName).collect(Collectors.toSet()));
        int threadsCount = 10;
        String property = System.getProperty(SystemPropertyKey.VERIFIER_THREAD_COUNT.key);
        if (property != null) {
            try {
                threadsCount = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.executorService = Executors.newFixedThreadPool(threadsCount);
    }

    private ConcurrentMap<String, Long> getExpectedArtefacts(Project project) {
        Stream artefacts = Stream.concat(project.getSoftware().getArtefacts().getArtefact().stream(), project.getConfiguration().getArtefacts().getArtefact().stream());
        return artefacts.filter(artefact -> artefact.getFile() != null).collect(Collectors.toConcurrentMap(ArtefactType::getFile, ArtefactType::getLength));
    }

    private Map<String, Long> getInflatedFilesFromArtefacts(Project project) {
        HashMap<String, Long> files = new HashMap<String, Long>();
        this.extractedFiles.clear();
        Stream artefacts = Stream.concat(project.getSoftware().getArtefacts().getArtefact().stream(), project.getConfiguration().getArtefacts().getArtefact().stream());
        artefacts.filter(artefact -> artefact.getFile() != null && Boolean.TRUE.equals(artefact.isInflate())).forEach(artefact -> {
            Collection<Path> extracted = ArtefactUpdater.inflate(artefact, this.libsFolder);
            this.extractedFiles.addAll(extracted);
            for (Path file : extracted) {
                try {
                    long size = Files.size(file);
                    files.put(file.toAbsolutePath().toString(), size);
                }
                catch (IOException e) {
                    Logger.error((String)("Could not get size of file " + file), (Throwable)e);
                }
            }
        });
        return files;
    }

    public Set<Path> getExtractedFiles() {
        return this.extractedFiles;
    }

    private void verifyFile(Path file, @Nullable Increasable increasable, AtomicBoolean success) {
        try {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                if (increasable != null) {
                    increasable.increase(1L);
                }
                if (file.toString().endsWith(".jar")) {
                    JarVerifier.verify((Path)file);
                }
                this.verifyExpectedFile(file);
            } else if (Files.isDirectory(file, new LinkOption[0]) && Objects.requireNonNull(file.toFile().list()).length == 0) {
                Files.delete(file);
            }
        }
        catch (IOException | SecurityException e) {
            Logger.error((String)"Verifying project files failed", (Throwable)e);
            success.set(false);
        }
    }

    public boolean verify(@Nullable Increasable increasable) {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException(this.getClass().getName() + " can only be used once per instantiation");
        }
        AtomicBoolean success = new AtomicBoolean(true);
        if (!this.missingArtefacts.isEmpty()) {
            Logger.error((String)("Required files were not found or have incorrect size:\n" + String.join((CharSequence)"\n", this.missingArtefacts)));
            success.set(false);
        }
        long start = System.currentTimeMillis();
        try (Stream<Path> tree = Files.walk(this.libsFolder, new FileVisitOption[0]);){
            tree.forEach(file -> this.executorService.execute(() -> this.verifyFile((Path)file, increasable, success)));
            this.executorService.shutdown();
            success.compareAndSet(true, this.executorService.awaitTermination(2L, TimeUnit.MINUTES));
        }
        catch (IOException | SecurityException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Logger.debug((String)("Verification took: " + (double)(System.currentTimeMillis() - start) / 1000.0));
        if (!this.expectedFiles.isEmpty()) {
            Logger.error((String)("Required files were not found or have incorrect size:\n" + String.join((CharSequence)"\n", this.expectedFiles.keySet())));
            success.set(false);
        }
        if (!this.unexpectedFiles.isEmpty()) {
            Logger.error((String)("Unexpected files were found:\n" + this.unexpectedFiles.stream().map(Path::toString).collect(Collectors.joining("\n"))));
            success.set(false);
        }
        return success.get();
    }

    private void verifyExpectedFile(Path file) {
        String absolutePath = file.toAbsolutePath().toString();
        Long foundLength = (Long)this.expectedFiles.get(absolutePath);
        if (foundLength != null) {
            try {
                long size = Files.size(file);
                if (size == foundLength) {
                    this.expectedFiles.remove(absolutePath);
                }
            }
            catch (IOException e) {
                Logger.error((String)("Could not get size of file " + file), (Throwable)e);
            }
        } else {
            this.unexpectedFiles.add(file);
        }
    }
}

