/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import com.sun.istack.Nullable;
import de.governikus.updater.SystemPropertyKey;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Stream;

public class Logger {
    private static final int MIN_LENGTH = 80;
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty(SystemPropertyKey.UPDATER_DEBUG.key, Boolean.FALSE.toString()));
    public static final boolean TO_FILE = System.getProperty(SystemPropertyKey.UPDATER_OUTPUT_FILE.key) != null;
    public static final boolean TO_CONSOLE = Boolean.parseBoolean(System.getProperty(SystemPropertyKey.UPDATER_OUTPUT_CONSOLE.key, Boolean.TRUE.toString()));
    private static Path updaterLogFile;
    private static Queue<ScheduledMessage> beforeInitialized;

    @Nullable
    private static Path getUpdaterLogFile(Path appFolder) {
        Path file = appFolder.resolve("updater.log");
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)("\n\n__________________________________________\nSession started at " + LocalDateTime.now() + "\n"), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }

    private static void redirectSystemErrOut(Path errFile, Path outFile) {
        try {
            final PrintStream oldErrStream = System.err;
            final PrintStream oldOutStream = System.out;
            final OutputStream errFileStream = Files.newOutputStream(errFile, new OpenOption[0]);
            final OutputStream outFileStream = Files.newOutputStream(outFile, new OpenOption[0]);
            if (TO_CONSOLE) {
                OutputStream newErrStream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        oldErrStream.write(b);
                        errFileStream.write(b);
                    }
                };
                OutputStream newOutStream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        oldOutStream.write(b);
                        outFileStream.write(b);
                    }
                };
                System.setErr(new PrintStream(newErrStream, true));
                System.setOut(new PrintStream(newOutStream, true));
            } else {
                System.setErr(new PrintStream(errFileStream, true));
                System.setOut(new PrintStream(outFileStream, true));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void logPreInitializationMessages() {
        Queue<ScheduledMessage> before = beforeInitialized;
        beforeInitialized = null;
        while (before != null && !before.isEmpty()) {
            ScheduledMessage message = before.poll();
            Logger.log(message.type, message.message, message.throwable);
        }
    }

    private static Path setupTempDir(Path appFolder) {
        Path tempDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve(System.getProperty(SystemPropertyKey.MANUFACTURER_NAME.key)).resolve(appFolder.getFileName());
        final Instant beforeIsOutdated = Instant.now().minus(1L, ChronoUnit.HOURS);
        try {
            if (Files.exists(tempDir, new LinkOption[0])) {
                Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        FileVisitResult result = super.visitFile(file, attrs);
                        if (result == FileVisitResult.CONTINUE && file.getFileName().toString().endsWith(".log") && Files.getLastModifiedTime(file, new LinkOption[0]).toInstant().isBefore(beforeIsOutdated)) {
                            Files.delete(file);
                        }
                        return result;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        FileVisitResult result = super.postVisitDirectory(dir, exc);
                        try (Stream<Path> stream = Files.list(dir);){
                            if (stream.findAny().isEmpty()) {
                                Files.delete(dir);
                            }
                        }
                        return result;
                    }
                });
            }
            Files.createDirectories(tempDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempDir;
    }

    public static void initLogFiles(Path appFolder) {
        if (TO_FILE) {
            updaterLogFile = Logger.getUpdaterLogFile(appFolder);
        }
        Path tempDir = Logger.setupTempDir(appFolder);
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        Path errFile = tempDir.resolve(time.format(dtf) + ".err.log");
        Path outFile = tempDir.resolve(time.format(dtf) + ".out.log");
        try {
            Files.createFile(errFile, new FileAttribute[0]);
            Files.createFile(outFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            errFile = null;
            outFile = null;
        }
        if (errFile != null) {
            Logger.redirectSystemErrOut(errFile, outFile);
        }
        Logger.logPreInitializationMessages();
    }

    public static void info(String message) {
        Logger.log(Type.INFO, message, null);
    }

    public static void info(Throwable t) {
        Logger.log(Type.INFO, null, t);
    }

    public static void info(String message, Throwable t) {
        Logger.log(Type.INFO, message, t);
    }

    public static void debug(String message) {
        Logger.log(Type.DEBUG, message, null);
    }

    public static void debug(Throwable t) {
        Logger.log(Type.DEBUG, null, t);
    }

    public static void debug(String message, Throwable t) {
        Logger.log(Type.DEBUG, message, t);
    }

    public static void error(String message) {
        Logger.log(Type.ERROR, message, null);
    }

    public static void error(Throwable throwable) {
        Logger.log(Type.ERROR, null, throwable);
    }

    public static void error(String message, Throwable throwable) {
        Logger.log(Type.ERROR, message, throwable);
    }

    private static StackTraceElement getCalledFrom() {
        Throwable throwable = new Throwable();
        for (StackTraceElement element : throwable.getStackTrace()) {
            String className = element.getClassName();
            if (className.equals(Logger.class.getName())) continue;
            return element;
        }
        return null;
    }

    private static String formatCaller(StackTraceElement caller) {
        StringBuilder sb = new StringBuilder();
        sb.append(caller.getClassName());
        sb.append('.');
        sb.append(caller.getMethodName());
        sb.append('(');
        sb.append(caller.getFileName());
        sb.append(':');
        if (caller.isNativeMethod()) {
            sb.append("native");
        } else if (caller.getLineNumber() < 0) {
            sb.append("unknown");
        } else {
            sb.append(caller.getLineNumber());
        }
        sb.append(')');
        int missing = 80 - sb.length();
        if (missing > 0) {
            sb.append(" ".repeat(missing));
        }
        return sb.toString();
    }

    private static synchronized void log(Type type, String msg, Throwable throwable) {
        if (type == Type.DEBUG && !DEBUG) {
            return;
        }
        if (beforeInitialized != null) {
            beforeInitialized.offer(new ScheduledMessage(type, msg, throwable));
            return;
        }
        StackTraceElement caller = Logger.getCalledFrom();
        if (caller == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LocalTime.now().truncatedTo(ChronoUnit.MICROS));
        sb.append(' ');
        sb.append(type.toString());
        sb.append(' ');
        sb.append(Logger.formatCaller(caller));
        sb.append(" : ");
        if (msg != null) {
            sb.append(msg);
        }
        if (throwable != null) {
            sb.append('\n');
            sb.append('\t');
            sb.append('\t');
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            sb.append(sw);
        }
        String message = sb.toString();
        if (TO_FILE && updaterLogFile != null) {
            Logger.appendToFile(message);
        }
        Logger.writeToSystemStreams(type, message);
    }

    private static void writeToSystemStreams(Type type, String message) {
        if (type == Type.ERROR) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    private static void appendToFile(String message) {
        try {
            Files.writeString(updaterLogFile, (CharSequence)(message + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Can't write to file " + e);
        }
    }

    static {
        beforeInitialized = new LinkedList<ScheduledMessage>();
    }

    private static class ScheduledMessage {
        Type type;
        String message;
        Throwable throwable;

        ScheduledMessage(Type type, String message, Throwable throwable) {
            this.type = type;
            this.message = message;
            this.throwable = throwable;
        }
    }

    public static enum Type {
        INFO,
        DEBUG,
        ERROR;


        public String toString() {
            if (this == INFO) {
                return this.name() + " ";
            }
            return this.name();
        }
    }
}

