/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;

public class Utils {
    private static FileLock lock = null;
    private static FileOutputStream fos;

    private Utils() {
    }

    public static synchronized void lock(File lockFile) throws IOException {
        if (lock != null) {
            return;
        }
        File parentFolder = lockFile.getParentFile();
        if (!parentFolder.exists() && !parentFolder.mkdirs()) {
            Logger.info("cant create dir: " + lockFile.getParentFile().getAbsolutePath());
            return;
        }
        fos = new FileOutputStream(lockFile);
        FileChannel fc = fos.getChannel();
        lock = fc.tryLock();
    }

    public static synchronized boolean isLocked(File lockFile) {
        if (!lockFile.exists()) {
            return false;
        }
        try {
            Files.delete(lockFile.toPath());
        }
        catch (IOException ex) {
            Logger.info("could not delete file: " + lockFile);
        }
        return lockFile.exists();
    }

    public static synchronized void unlock(File lockFile) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException ex) {
                Logger.info("LockFile \"" + lockFile.getAbsolutePath() + "\" can not unlock!");
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                        try {
                            Files.delete(lockFile.toPath());
                        }
                        catch (IOException ex) {
                            Logger.info("could not delete file: " + lockFile);
                        }
                    }
                    catch (IOException ex) {
                        Logger.info(ex);
                    }
                }
                lockFile = null;
                lock = null;
            }
        }
    }

    public static boolean runningInConsole() {
        String sessionName = System.getProperty("SESSIONNAME", null);
        return sessionName != null && "Console".equalsIgnoreCase(sessionName.trim());
    }

    public static String getValidFileName(String filename) {
        filename = filename.replace("u\u0308", "\u00fc").replace("o\u0308", "\u00f6").replace("a\u0308", "\u00e4").replace("U\u0308", "\u00dc").replace("O\u0308", "\u00d6").replace("A\u0308", "\u00c4");
        filename = filename.replace('/', ' ');
        filename = filename.replace(':', ' ');
        filename = filename.replace('*', ' ');
        filename = filename.replace('?', ' ');
        filename = filename.replace('\\', ' ');
        filename = filename.replace('<', ' ');
        filename = filename.replace('>', ' ');
        filename = filename.replace('|', ' ');
        filename = filename.replace('\\', ' ');
        filename = filename.replace('&', ' ');
        filename = filename.replace('\n', ' ');
        return filename.replace('\r', ' ');
    }

    public static String getLocalPath(ArtefactType artefactType) {
        return Utils.getLocalPath(artefactType, false);
    }

    public static String getLocalPath(ArtefactType artefactType, boolean folder) {
        StringBuilder path = new StringBuilder();
        if (folder) {
            path.append('/');
        }
        if (artefactType.getOs() != null) {
            path.append(artefactType.getOs().value());
            if (!folder) {
                path.append('/');
            }
        }
        if (artefactType.getArch() != null) {
            if (folder) {
                path.append('/');
            }
            path.append(artefactType.getArch().value());
            if (!folder) {
                path.append('/');
            }
        }
        if (!folder) {
            path.append(artefactType.getName());
        }
        return path.toString();
    }

    public static String getID(ArtefactType a) {
        return a.getName() + a.getOs() + a.getArch();
    }
}

