/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.fetching;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Project;
import de.governikus.updater.Utils;
import de.governikus.updater.fetching.ProjectFetcher;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class DistributingProjectFetcher
extends ProjectFetcher {
    private final Path file;

    public DistributingProjectFetcher(Path file) {
        this.file = file;
    }

    private void setArtefactFiles(List<ArtefactType> artefacts) {
        Path parent = this.file.getParent();
        for (ArtefactType artefactType : artefacts) {
            Path artefactFile = parent.resolve(Utils.getLocalPath(artefactType));
            artefactType.setFile(artefactFile.toAbsolutePath().toString());
        }
    }

    @Override
    public Project getProject() throws IOException, SAXException, JAXBException, XMLStreamException {
        if (this.project == null) {
            this.project = new Project();
            this.project.setProjectType(ProjectFetcher.parseUpdateXml(this.file));
            List<ArtefactType> allArtefacts = Stream.concat(this.project.getSoftware().getArtefacts().getArtefact().stream(), this.project.getConfiguration().getArtefacts().getArtefact().stream()).collect(Collectors.toList());
            this.setArtefactFiles(allArtefacts);
        }
        return this.project;
    }
}

