/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.fetching;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Logger;
import de.governikus.updater.Project;
import de.governikus.updater.SystemPropertyKey;
import de.governikus.updater.Utils;
import de.governikus.updater.fetching.ProjectFetcher;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class LocalProjectFetcher
extends ProjectFetcher {
    private final Path file;
    private final Path artefactDirectory;

    public LocalProjectFetcher(Path file, Path artefactDirectory) {
        this.file = file;
        this.artefactDirectory = artefactDirectory;
    }

    public LocalProjectFetcher(Path file) {
        this.file = file;
        this.artefactDirectory = null;
    }

    private void setArtefactFiles(List<ArtefactType> artefacts) {
        if (this.artefactDirectory == null) {
            return;
        }
        Path base = this.artefactDirectory.toAbsolutePath();
        for (ArtefactType artefactType : artefacts) {
            try {
                Path artefactFile = base.resolve(Utils.getLocalPath(artefactType));
                if (!Files.exists(artefactFile, new LinkOption[0])) {
                    Logger.debug(artefactFile.toAbsolutePath() + ": not existing");
                    continue;
                }
                if (Files.size(artefactFile) != artefactType.getLength()) {
                    Logger.debug(artefactFile.toAbsolutePath() + ": length mismatch");
                    continue;
                }
                artefactType.setFile(artefactFile.toAbsolutePath().toString());
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Project getProject() throws IOException, SAXException, JAXBException, XMLStreamException {
        if (this.project == null) {
            this.project = new Project();
            this.project.setProjectType(this.loadProjectType(this.file));
            List<ArtefactType> allArtefacts = Stream.concat(this.project.getSoftware().getArtefacts().getArtefact().stream(), this.project.getConfiguration().getArtefacts().getArtefact().stream()).collect(Collectors.toList());
            this.setArtefactFiles(allArtefacts);
        }
        return this.project;
    }

    public static void setInstallerVersion(Project project) {
        project.getInstallation().setVersion(System.getProperty(SystemPropertyKey.INSTALLER_VERSION.key));
    }
}

