/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.fetching;

import com.sun.istack.Nullable;
import de.governikus.updater.ArchType;
import de.governikus.updater.ArtefactListType;
import de.governikus.updater.CertificateListType;
import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import de.governikus.updater.Project;
import de.governikus.updater.ProjectType;
import de.governikus.updater.security.CertStorage;
import de.governikus.updater.security.XmlVerifier;
import de.governikus.updater.utils.SystemEnvironment;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class ProjectFetcher {
    protected Project project;

    @Nullable
    public abstract Project getProject() throws IOException, SAXException, JAXBException, XMLStreamException, GeneralSecurityException;

    protected ProjectType loadProjectType(Path file) throws XMLStreamException, JAXBException, IOException, SAXException {
        ProjectType projectType = ProjectFetcher.parseUpdateXml(file);
        ProjectFetcher.verifyProjectType(file, projectType);
        X509Certificate certificate = ProjectFetcher.getCertificate(projectType);
        if (certificate != null) {
            CertStorage.getInstance().addTrustedCertificate(certificate);
        } else {
            Logger.info("No certificate was retrieved from the update xml");
        }
        ProjectFetcher.removeMismatchedOsArch(projectType.getSoftware().getArtefacts());
        ProjectFetcher.removeMismatchedOsArch(projectType.getConfiguration().getArtefacts());
        return projectType;
    }

    @Nullable
    protected static ProjectType parseUpdateXml(Path file) throws IOException, SAXException, JAXBException, XMLStreamException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Source[] schemaSources = new Source[]{new StreamSource(ProjectType.class.getResourceAsStream("/xsd/xmldsig-core-schema.xsd")), new StreamSource(ProjectType.class.getResourceAsStream("/xsd/update.xsd"))};
        Schema schema = factory.newSchema(schemaSources);
        JAXBContext context = JAXBContext.newInstance((String)"de.governikus.updater");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = xif.createXMLStreamReader(Files.newInputStream(file, new OpenOption[0]));
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(xsr);
        return (ProjectType)jaxbElement.getValue();
    }

    protected static void verifyProjectType(Path xml, ProjectType projectType) {
        if (projectType.getSignature() == null) {
            throw new SecurityException("project xml file is not signed.");
        }
        if (!XmlVerifier.verifyXMLSignature(xml)) {
            throw new SecurityException("Signature of project xml file is invalid.");
        }
    }

    protected static X509Certificate getCertificate(ProjectType projectType) {
        List certificateBytes;
        Iterator iterator;
        CertificateListType certificateList = projectType.getCertificateList();
        if (certificateList != null && (iterator = (certificateBytes = certificateList.getCertificate()).iterator()).hasNext()) {
            byte[] bytes = (byte[])iterator.next();
            try {
                return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(bytes));
            }
            catch (CertificateException e) {
                throw new SecurityException(e);
            }
        }
        return null;
    }

    protected static void removeMismatchedOsArch(ArtefactListType artefactTypes) {
        OSType os = SystemEnvironment.currentOSType();
        ArchType arch = SystemEnvironment.currentArchType();
        List artefacts = artefactTypes.getArtefact();
        artefacts.removeIf(artefact -> artefact.getOs() != null && artefact.getOs() != os || artefact.getArch() != null && artefact.getArch() != arch);
    }
}

