/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.fetching;

import de.governikus.updater.ArtefactType;
import de.governikus.updater.Project;
import de.governikus.updater.Utils;
import de.governikus.updater.fetching.ProjectFetcher;
import de.governikus.updater.utils.FileSystemUtils;
import jakarta.xml.bind.JAXBException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class RemoteProjectFetcher
extends ProjectFetcher {
    private final URL url;
    private final Path tempFetchedFile;

    public RemoteProjectFetcher(URL url, Path localAppFolder) throws IOException {
        this.url = url;
        Path file = localAppFolder.resolve("tempUpdate.xml");
        if (Files.isDirectory(file, new LinkOption[0])) {
            FileSystemUtils.deleteDirectory(file);
        }
        Files.deleteIfExists(file);
        this.tempFetchedFile = Files.createFile(file, new FileAttribute[0]);
        this.tempFetchedFile.toFile().deleteOnExit();
    }

    private static void downloadFile(URL sourceUrl, Path destinationFile) throws IOException {
        if (!sourceUrl.getFile().toLowerCase().endsWith(".xml")) {
            throw new SecurityException("Disallowed file extension: " + sourceUrl);
        }
        URLConnection connection = sourceUrl.openConnection();
        connection.setUseCaches(false);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(connection.getInputStream());
             FileOutputStream fileOutputStream = new FileOutputStream(destinationFile.toFile());){
            long transferred;
            FileChannel fileChannel = fileOutputStream.getChannel();
            long position = 0L;
            while ((transferred = fileChannel.transferFrom(readableByteChannel, position, Long.MAX_VALUE)) > 0L) {
                position += transferred;
            }
        }
    }

    public void saveUpdateXmlTo(Path file, CopyOption ... options) throws IOException {
        if (!Files.exists(this.tempFetchedFile, new LinkOption[0])) {
            RemoteProjectFetcher.downloadFile(this.url, this.tempFetchedFile);
        }
        Files.copy(this.tempFetchedFile, file, options);
    }

    private void setArtefactFiles(List<ArtefactType> artefacts) {
        String location = this.url.toString().substring(0, this.url.toString().lastIndexOf(47) + 1);
        for (ArtefactType artefactType : artefacts) {
            artefactType.setFile(location + Utils.getLocalPath(artefactType));
        }
    }

    @Override
    public Project getProject() throws IOException, SAXException, JAXBException, XMLStreamException {
        if (this.project == null) {
            this.project = new Project();
            RemoteProjectFetcher.downloadFile(this.url, this.tempFetchedFile);
            this.project.setProjectType(this.loadProjectType(this.tempFetchedFile));
            List<ArtefactType> allArtefacts = Stream.concat(this.project.getSoftware().getArtefacts().getArtefact().stream(), this.project.getConfiguration().getArtefacts().getArtefact().stream()).collect(Collectors.toList());
            this.setArtefactFiles(allArtefacts);
        }
        return this.project;
    }
}

