/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.security;

import com.sun.istack.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class CertStorage {
    private static final CertStorage instance = new CertStorage();
    private final Set<TrustAnchor> trustAnchorSet = new HashSet<TrustAnchor>(2);
    private static PublicKey publicKey = null;

    public static CertStorage getInstance() {
        return instance;
    }

    private CertStorage() {
        TrustAnchor anchor = new TrustAnchor("CN=Governikus Updater,O=Governikus GmbH & Co. KG,C=DE", CertStorage.getPublicKey(), null);
        this.trustAnchorSet.add(anchor);
    }

    @Nullable
    static PublicKey getPublicKey() {
        if (publicKey != null) {
            return publicKey;
        }
        try {
            String key;
            try (InputStream is = CertStorage.class.getResourceAsStream("gov-updater_public.pem");){
                key = new String(Objects.requireNonNull(is).readAllBytes());
            }
            String publicKeyPEM = key.replace("-----BEGIN PUBLIC KEY-----", "").replaceAll("[\\n\\r]", "").replace("-----END PUBLIC KEY-----", "");
            byte[] encoded = Base64.getDecoder().decode(publicKeyPEM);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SecurityException(e);
        }
    }

    public void addTrustedCertificate(X509Certificate certificate) {
        this.trustAnchorSet.add(new TrustAnchor(certificate, null));
    }

    public Set<TrustAnchor> getTrustAnchorSet() {
        return this.trustAnchorSet;
    }
}

