/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.security;

import de.governikus.updater.Logger;
import de.governikus.updater.security.CertStorage;
import de.governikus.updater.security.ZipFileLimiter;
import java.io.IOException;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class JarVerifier {
    private JarVerifier() {
    }

    private static void verifySignedEntries(Path file, JarFile jarFile, Set<String> signedEntries) throws IOException, SecurityException {
        boolean anySigners = false;
        HashSet<String> originallySignedEntries = new HashSet<String>(signedEntries);
        ZipFileLimiter zipFileLimiter = new ZipFileLimiter(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            zipFileLimiter.addEntry();
            ZipFileLimiter.SafeInputStream stream = zipFileLimiter.getSafeInputStreamFor(jarFile.getInputStream(entry));
            stream.readAllBytes();
            CodeSigner[] codeSigners = entry.getCodeSigners();
            if (codeSigners != null) {
                anySigners |= !entry.getName().endsWith("META-INF/MANIFEST.MF");
                GeneralSecurityException thrown = null;
                boolean validatedThisEntry = false;
                for (CodeSigner codeSigner : codeSigners) {
                    CertPath signerCertPath = codeSigner.getSignerCertPath();
                    try {
                        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                        Set<TrustAnchor> trustAnchors = CertStorage.getInstance().getTrustAnchorSet();
                        PKIXParameters parameters = new PKIXParameters(trustAnchors);
                        parameters.setRevocationEnabled(false);
                        validator.validate(signerCertPath, parameters);
                        validatedThisEntry = true;
                        break;
                    }
                    catch (GeneralSecurityException e) {
                        thrown = e;
                    }
                }
                if (!validatedThisEntry) {
                    throw new SecurityException(jarFile.getName(), thrown);
                }
            }
            originallySignedEntries.remove(entry.getName());
        }
        if (!anySigners) {
            Logger.error("Unsigned jar file was found in libs folder: " + jarFile.getName());
            throw new SecurityException("no code signers could be retrieved for " + jarFile.getName());
        }
        if (!originallySignedEntries.isEmpty()) {
            Logger.error("Signed jar file has been manipulated: " + jarFile.getName());
            throw new SecurityException("some signed entries have been removed from " + jarFile.getName() + ": " + String.join((CharSequence)", ", originallySignedEntries));
        }
    }

    private static void getUnsignedEntries(Path file, JarFile jarFile, Set<String> signed, Set<String> unsigned) throws IOException {
        Manifest manifest = new Manifest(jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF")));
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            String name = entry.getKey();
            Attributes attributes = entry.getValue();
            for (Object key : attributes.keySet()) {
                if (!(key instanceof Attributes.Name) || !key.toString().endsWith("-Digest")) continue;
                signed.add(name);
            }
        }
        ZipFileLimiter zipFileLimiter = new ZipFileLimiter(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            zipFileLimiter.addEntry();
            if (entry.isDirectory() || signed.contains(entry.getName())) continue;
            unsigned.add(entry.getName());
        }
    }

    private static boolean isDigitalSignature(JarEntry entry) {
        String shortName = entry.getName().substring(entry.getName().lastIndexOf("/") + 1);
        int period = shortName.lastIndexOf(".");
        String extension = shortName.substring(period + 1);
        String withoutExtension = shortName.substring(0, period);
        List<String> recognizedDigitalSignatureExtensions = List.of("RSA", "DSA", "EC");
        if (recognizedDigitalSignatureExtensions.contains(extension)) {
            return true;
        }
        if (withoutExtension.startsWith("SIG-")) {
            if (!extension.matches("^[a-zA-Z0-9]{1,3}$")) {
                throw new SecurityException("the file extension of the digital signature file " + entry.getName() + " may only be 1 to 3 alphanumerical characters");
            }
            return true;
        }
        return false;
    }

    private static void verifyUnsignedEntries(JarFile jarFile, Set<String> unsignedEntries) throws SecurityException {
        String metaInf = "META-INF/";
        HashSet<String> signatureFiles = new HashSet<String>();
        HashMap digitalSignatures = new HashMap();
        for (String entryName : unsignedEntries) {
            JarEntry entry = jarFile.getJarEntry(entryName);
            String withoutPath = entryName.replace(metaInf, "");
            if (!entryName.startsWith(metaInf) || withoutPath.contains("/")) {
                throw new SecurityException("jar entry " + entryName + " is unsigned and outside of META-INF/");
            }
            String withoutExtension = withoutPath.substring(0, withoutPath.lastIndexOf("."));
            String extension = withoutPath.substring(withoutPath.lastIndexOf(".") + 1);
            if (extension.equals("SF")) {
                signatureFiles.add(withoutExtension);
                continue;
            }
            if (JarVerifier.isDigitalSignature(entry)) {
                digitalSignatures.putIfAbsent(withoutExtension, new ArrayList());
                ((List)digitalSignatures.get(withoutExtension)).add(extension);
                continue;
            }
            if (withoutPath.equals("MANIFEST.MF")) continue;
            throw new SecurityException("the jar file " + jarFile.getName() + " contains an invalid entry: " + entryName);
        }
        for (String signature : signatureFiles) {
            if (!digitalSignatures.containsKey(signature) || ((List)digitalSignatures.get(signature)).isEmpty()) {
                throw new SecurityException("no digital signature exists for the signature '" + signature + "' in the jar file " + jarFile.getName());
            }
            digitalSignatures.remove(signature);
        }
        if (!digitalSignatures.isEmpty()) {
            String files = digitalSignatures.entrySet().stream().map(pair -> "[ " + ((List)pair.getValue()).stream().map(extension -> (String)pair.getKey() + "." + extension).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(", "));
            throw new SecurityException("jar file " + jarFile.getName() + " contains digital signatures without corresponding signature file: " + files);
        }
    }

    public static void verify(Path file) throws IOException, SecurityException {
        Logger.debug("Verifying jar file " + file);
        try (JarFile jar = new JarFile(file.toFile());){
            HashSet<String> signedEntries = new HashSet<String>();
            HashSet<String> unsignedEntries = new HashSet<String>();
            JarVerifier.getUnsignedEntries(file, jar, signedEntries, unsignedEntries);
            JarVerifier.verifySignedEntries(file, jar, signedEntries);
            JarVerifier.verifyUnsignedEntries(jar, unsignedEntries);
        }
    }
}

