/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.security;

import de.governikus.updater.security.XmlUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlSigner {
    private XmlSigner() {
    }

    public static void applyXMLSignature(Path file, KeyStore ks, String alias, char[] priKPassword) throws GeneralSecurityException, IOException, SAXException, ParserConfigurationException, MarshalException, XMLSignatureException, TransformerException {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        LinkedList<Transform> transforms = new LinkedList<Transform>();
        transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null));
        Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), transforms, null, null);
        SignatureMethod signatureMethod = fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        SignedInfo si = fac.newSignedInfo((CanonicalizationMethod)transforms.get(1), signatureMethod, Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        X509Certificate c = (X509Certificate)ks.getCertificate(alias);
        x509Content.add(c.getSubjectX500Principal().getName());
        x509Content.add(c);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        Document doc = XmlUtils.getDBF().newDocumentBuilder().parse(Files.newInputStream(file, new OpenOption[0]));
        PrivateKey priK = (PrivateKey)ks.getKey(alias, priKPassword);
        DOMSignContext dsc = new DOMSignContext(priK, (Node)doc.getDocumentElement());
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(doc), new StreamResult(os));
        }
    }
}

