/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.security;

import de.governikus.updater.security.CertStorage;
import de.governikus.updater.security.XmlUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlVerifier {
    private XmlVerifier() {
    }

    public static boolean verifyXMLSignature(Path xml) {
        return XmlVerifier.verifyXMLSignature(xml, CertStorage.getPublicKey());
    }

    private static boolean verifyXMLSignature(Path xml, final PublicKey publicKey) {
        try {
            Document doc = XmlUtils.getDBF().newDocumentBuilder().parse(Files.newInputStream(xml, new OpenOption[0]));
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() != 1) {
                throw new IOException("Number of Signature elements is not 1 (" + nl.getLength() + ")");
            }
            Element signature = (Element)nl.item(0);
            if (!((Element)signature.getFirstChild()).getElementsByTagName("Reference").item(0).getAttributes().getNamedItem("URI").getNodeValue().isEmpty()) {
                throw new IllegalArgumentException("Signature does not refer to document root \"\"");
            }
            DOMValidateContext valContext = new DOMValidateContext(new KeySelector(){

                @Override
                public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) {
                    return () -> publicKey;
                }
            }, nl.item(0));
            valContext.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            XMLSignature xmlSig = fac.unmarshalXMLSignature(valContext);
            return xmlSig.validate(valContext);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

