/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.security;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;

public class ZipFileLimiter {
    public static final int DEFAULT_MAX_ZIP_ENTRIES = 20000;
    private final int maxZipEntries;
    public static final long DEFAULT_MAX_ZIP_SIZE = 1000000000L;
    private final long maxZipSize;
    public static final double DEFAULT_MAX_COMPRESSION_RATIO = 10.0;
    private final double maxCompressionRatio;
    private final String name;
    private int zipEntries = 0;
    private long zipSize = 0L;
    private final long totalCompressedSize;

    public ZipFileLimiter(Path file, @Nullable Integer maxZipEntries, @Nullable Long maxZipSize, @Nullable Double maxCompressionRatio) {
        this.name = file.getFileName().toString();
        try {
            this.totalCompressedSize = Files.size(file);
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
        this.maxZipEntries = Objects.requireNonNullElse(maxZipEntries, 20000);
        this.maxZipSize = Objects.requireNonNullElse(maxZipSize, 1000000000L);
        this.maxCompressionRatio = Objects.requireNonNullElse(maxCompressionRatio, 10.0);
    }

    public ZipFileLimiter(Path file) {
        this(file, null, null, null);
    }

    public void addEntry() {
        ++this.zipEntries;
        if (this.zipEntries > this.maxZipEntries) {
            throw new SecurityException(String.format("Too many entries in archive file %s. Maximum allowed is %d", this.name, this.maxZipEntries));
        }
    }

    public void increaseSize(long bytes) {
        this.zipSize += bytes;
        if (this.zipSize > this.maxZipSize) {
            throw new SecurityException(String.format("Too much uncompressed data in archive file %s. Maximum allowed is %d", this.name, this.maxZipSize));
        }
        double compressionRatio = (double)this.zipSize / (double)this.totalCompressedSize;
        if (compressionRatio > this.maxCompressionRatio) {
            throw new SecurityException(String.format("Compression ratio too big in archive file %s. Maximum allowed is %f", this.name, this.maxCompressionRatio));
        }
    }

    public SafeInputStream getSafeInputStreamFor(InputStream zipInputStream) {
        return new SafeInputStream(zipInputStream);
    }

    public class SafeInputStream
    extends InputStream {
        private static final long CHECK_INTERVAL = 8192L;
        private long currentBlock = 0L;
        private final InputStream innerStream;

        private SafeInputStream(InputStream innerStream) {
            this.innerStream = innerStream;
        }

        @Override
        public int read() throws IOException {
            ++this.currentBlock;
            if (this.currentBlock >= 8192L) {
                ZipFileLimiter.this.increaseSize(this.currentBlock);
                this.currentBlock = 0L;
            }
            return this.innerStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            int read = this.innerStream.read(b, off, len);
            if (read > 0) {
                ZipFileLimiter.this.increaseSize(read);
            }
            return read;
        }
    }
}

