/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.utils;

import de.governikus.updater.Logger;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static boolean isNonexistentFileWritable(Path file) {
        boolean result;
        try {
            Files.createFile(file, new FileAttribute[0]);
            result = Files.isWritable(file);
            Files.delete(file);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public static boolean isDirectoryWritable(Path directory, boolean recursive) {
        List directChildren;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> childrenStream = Files.list(directory);){
            directChildren = childrenStream.collect(Collectors.toList());
        }
        catch (IOException e) {
            return false;
        }
        if (directChildren.isEmpty()) {
            Path tempFile = directory.resolve(".TEMPORARY_TEST_FILE");
            boolean result = FileSystemUtils.isNonexistentFileWritable(tempFile);
            Logger.debug((result ? "Can" : "Can't") + " write file " + tempFile);
            return result;
        }
        for (Path directChild : directChildren) {
            if (!Files.isWritable(directChild)) {
                Logger.debug("writable = false -> " + directChild);
                return false;
            }
            if (!recursive || !Files.isDirectory(directChild, new LinkOption[0]) || FileSystemUtils.isDirectoryWritable(directChild, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryCreateDirectories(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            return false;
        }
        return Files.exists(file, new LinkOption[0]);
    }

    public static void deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult result = super.visitFile(file, attrs);
                    if (result == FileVisitResult.CONTINUE) {
                        Files.delete(file);
                    }
                    return result;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    FileVisitResult result = super.postVisitDirectory(dir, exc);
                    if (result == FileVisitResult.CONTINUE) {
                        Files.delete(dir);
                    }
                    return result;
                }
            });
        }
    }

    public static void moveDirectory(final Path source, final Path target) throws IOException {
        try {
            Files.move(source, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.createDirectories(target, new FileAttribute[0]);
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path relative = source.relativize(dir);
                    Files.copy(dir, target.resolve(relative), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relative = source.relativize(file);
                    Files.copy(file, target.resolve(relative), new CopyOption[0]);
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void copyDirectory(final Path sourceParent, final Path destinationParent, final CopyOption ... options) throws IOException {
        Files.walkFileTree(sourceParent, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.preVisitDirectory(dir, attrs);
                if (result == FileVisitResult.CONTINUE) {
                    Files.createDirectories(destinationParent.resolve(sourceParent.relativize(dir)), new FileAttribute[0]);
                }
                return result;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.visitFile(file, attrs);
                if (result == FileVisitResult.CONTINUE) {
                    Files.copy(file, destinationParent.resolve(sourceParent.relativize(file)), options);
                }
                return result;
            }
        });
    }

    public static boolean tryDeleteFile(Path file) {
        try {
            return Files.deleteIfExists(file);
        }
        catch (IOException e) {
            return false;
        }
    }
}

