/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.utils;

import de.governikus.updater.ArchType;
import de.governikus.updater.Logger;
import de.governikus.updater.OSType;
import java.util.Arrays;
import java.util.Optional;

public class SystemEnvironment {
    private SystemEnvironment() {
    }

    public static ArchType currentArchType() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("86")) {
            return ArchType.B_32;
        }
        if (osArch.contains("64")) {
            return ArchType.B_64;
        }
        return null;
    }

    public static OSType currentOSType() {
        String osName = System.getProperty("os.name").toLowerCase();
        Optional<OSType> match = Arrays.stream(OSType.values()).filter(os -> osName.contains(os.name().toLowerCase())).findFirst();
        if (match.isPresent()) {
            Logger.debug("OSType: " + osName);
            return match.get();
        }
        Logger.error("Unknown os type: " + osName + ". Falling back to " + OSType.LINUX.value());
        return OSType.LINUX;
    }
}

